--
-- CaseCVX175
-- Specialization for CaseCVX175 mod
--
-- @author  	JoXXer
-- @date  		01/11/12
--

CaseCVX175 = {};

function CaseCVX175.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function CaseCVX175:load(xmlFile)
	self.frontLinkageBottomArmRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkageBottomArm#rotationNode"));
	setRotation(self.frontLinkageBottomArmRotNode, math.rad(0), math.rad(0), math.rad(0)); 
	
	self.frontLinkageBalls = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkageBalls#index"));
	self.rearLinkageBalls = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearLinkageBalls#index"));
	
	self.steeringColumn = {};
	self.steeringColumn.anim = getXMLString(xmlFile, "vehicle.steeringColumn#animName");
	self.steeringColumn.speed = getXMLFloat(xmlFile, "vehicle.steeringColumn#speed");
	
	self.moveDownIntervall = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.moveDownIntervall#ms"), 1000);
	self.updateJoint = false;
	self.doLowering = false;
	self.loweringDone = false;
	self.nextAction = false;
	self.delay = 0;
	self.implementCount = 0;
end;

function CaseCVX175:delete()
end;

function CaseCVX175:readStream(streamId, connection)
end;

function CaseCVX175:writeStream(streamId, connection)
end;

function CaseCVX175:readUpdateStream(streamId, timestamp, connection)
end;

function CaseCVX175:writeUpdateStream(streamId, connection, dirtyMask)
end;

function CaseCVX175:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CaseCVX175:keyEvent(unicode, sym, modifier, isDown)
end;

function CaseCVX175:update(dt)
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.LOWER_ALL_IMPLEMENTS) then
				if self.implementCount == 2 then			
					self.loweringDone = false;
					self.delay = self.moveDownIntervall;
					self.doLowering = true;
					self.nextAction = not self.attacherJoints[1].moveDown;
					if self.attacherJoints[2].moveDown ~= not self.nextAction then 
						self.nextAction = false;
					end;
				end;
			end;		
		end;
	end;
	
	-- Make parts move, magic
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;
	end;
end;

function CaseCVX175:updateTick(dt)
	if self:getIsActive() then	
		if self.doLowering then	
			local back = self.attacherJoints[1];
			local front = self.attacherJoints[2];	
			if not self.loweringDone then
				self:setJointMoveDown(2, self.nextAction);
				self.loweringDone = true;
			end;			
			if self.loweringDone then
				self.delay = self.delay - dt;				
				if self.delay <= 0 then
					self:setJointMoveDown(1, self.nextAction);
					self.doLowering = false;
				end;
			end;
		end;
	end;
end;

function CaseCVX175:draw()
	if self.implementCount == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_ALL_IMPLEMENTS"), InputBinding.LOWER_ALL_IMPLEMENTS);
	end;
end;

function CaseCVX175:onLeave()
	self:playAnimation(self.steeringColumn.anim, -self.steeringColumn.speed, Utils.clamp(self:getAnimationTime(self.steeringColumn.anim), 0, 1), true);
end;

function CaseCVX175:onEnter()
	self:playAnimation(self.steeringColumn.anim, self.steeringColumn.speed, Utils.clamp(self:getAnimationTime(self.steeringColumn.anim), 0, 1), true);
end;

function CaseCVX175:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;
		if jointIndex == 1 then
			setVisibility(self.rearLinkageBalls, true);
		elseif jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(-75), math.rad(0), math.rad(0)); 
			setVisibility(self.frontLinkageBalls, true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 3 then
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 4 then
		end;
	end;

	self.updateJoint = true;
end;

function CaseCVX175:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
		if jointIndex == 1 then
			setVisibility(self.rearLinkageBalls, false);
		elseif jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(0), math.rad(0), math.rad(0)); 
			setVisibility(self.frontLinkageBalls, false);
		end;
	else
	end;
end;

function CaseCVX175:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;
