-- @author:    	Xentro (www.ls-uk.info)

drumsDude = {};

function drumsDude.prerequisitesPresent(specializations)
    return true;
end;

function drumsDude:load(xmlFile)

	self.drums = {};
    local k = 0;
    while true do
        local key = string.format("vehicle.drums.drum(%d)", k);
        if not hasXMLProperty(xmlFile, key) then  break; end;
		
        local drumNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 50);
        local axis = Utils.getNoNil(getXMLString(xmlFile, key.."#axis"), "z");
        if drumNode ~= nil then
            table.insert(self.drums, {node = drumNode, speed = speed, axis = axis});
        end;
        k = k + 1;
    end;
end;

function drumsDude:delete()
end;

function drumsDude:mouseEvent(posX, posY, isDown, isUp, button)
end;

function drumsDude:keyEvent(unicode, sym, modifier, isDown)
end;

function drumsDude:update(dt)
	if self.isMotorStarted then
		for _, drumNode in pairs(self.drums) do
			local rot = drumNode.speed * dt;			
			if drumNode.axis == "x" then
				rotate(drumNode.node, rot, 0, 0);
			elseif drumNode.axis == "y" then
				rotate(drumNode.node, 0, rot, 0);
			elseif drumNode.axis == "z" then
				rotate(drumNode.node, 0, 0, rot);
			end;
		end;
	end;
end;

function drumsDude:draw()
end;
