PartesMoveis = {};

function PartesMoveis.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function PartesMoveis:load(xmlFile)
self.isSelectable = true
self.rollNodes = {};
	
    local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));
    if rollNode ~= nil then
        local speed = 0.003*3;
        table.insert(self.rollNodes, {node=rollNode, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if rollNode ~= nil then
            table.insert(self.rollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
	end;

self.roll1Nodes = {};
	
    local roll1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll1#index"));
    if roll1Node ~= nil then
        local speed = 0.003*3;
        table.insert(self.roll1Nodes, {node=roll1Node, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll1(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local roll1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if roll1Node ~= nil then
            table.insert(self.roll1Nodes, {node=roll1Node, speed=speed});
        end;
        i = i + 1;
	end;
	
	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	-- Ladder movements --
	
	local rotationNodeObjeto1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto1#index"));
    if rotationNodeObjeto1 ~= nil then
        self.rotationObjeto1 = {};
        self.rotationObjeto1.node = rotationNodeObjeto1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto1#minRot"));
        self.rotationObjeto1.minRot = {};
        self.rotationObjeto1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto1#maxRot"));
        self.rotationObjeto1.maxRot = {};
        self.rotationObjeto1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto1#rotTime"), 2)*1000;
        self.rotationObjeto1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto1#touchRotLimit"), 10));
    end;

	local rotationNodeObjeto2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto2#index"));
    if rotationNodeObjeto2 ~= nil then
        self.rotationObjeto2 = {};
        self.rotationObjeto2.node = rotationNodeObjeto2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto2#minRot"));
        self.rotationObjeto2.minRot = {};
        self.rotationObjeto2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto2#maxRot"));
        self.rotationObjeto2.maxRot = {};
        self.rotationObjeto2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto2#rotTime"), 2)*1000;
        self.rotationObjeto2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto2#touchRotLimit"), 10));
    end;

	local rotationNodeObjeto3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto3#index"));
    if rotationNodeObjeto3 ~= nil then
        self.rotationObjeto3 = {};
        self.rotationObjeto3.node = rotationNodeObjeto3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto3#minRot"));
        self.rotationObjeto3.minRot = {};
        self.rotationObjeto3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto3#maxRot"));
        self.rotationObjeto3.maxRot = {};
        self.rotationObjeto3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto3#rotTime"), 2)*1000;
        self.rotationObjeto3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto3#touchRotLimit"), 10));
    end;

	local rotationNodeObjeto4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto4#index"));
    if rotationNodeObjeto4 ~= nil then
        self.rotationObjeto4 = {};
        self.rotationObjeto4.node = rotationNodeObjeto4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto4#minRot"));
        self.rotationObjeto4.minRot = {};
        self.rotationObjeto4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto4#maxRot"));
        self.rotationObjeto4.maxRot = {};
        self.rotationObjeto4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto4#rotTime"), 2)*1000;
        self.rotationObjeto4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto4#touchRotLimit"), 10));
    end;

	local rotationNodeObjeto5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto5#index"));
    if rotationNodeObjeto5 ~= nil then
        self.rotationObjeto5 = {};
        self.rotationObjeto5.node = rotationNodeObjeto5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto5#minRot"));
        self.rotationObjeto5.minRot = {};
        self.rotationObjeto5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto5#maxRot"));
        self.rotationObjeto5.maxRot = {};
        self.rotationObjeto5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto5#rotTime"), 2)*1000;
        self.rotationObjeto5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto5#touchRotLimit"), 10));
    end;

	local rotationNodeObjeto6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto6#index"));
    if rotationNodeObjeto6 ~= nil then
        self.rotationObjeto6 = {};
        self.rotationObjeto6.node = rotationNodeObjeto6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto6#minRot"));
        self.rotationObjeto6.minRot = {};
        self.rotationObjeto6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto6#maxRot"));
        self.rotationObjeto6.maxRot = {};
        self.rotationObjeto6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto6#rotTime"), 2)*1000;
        self.rotationObjeto6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto6#touchRotLimit"), 10));
    end;	
	
	local rotationNodeObjeto7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto7#index"));
    if rotationNodeObjeto7 ~= nil then
        self.rotationObjeto7 = {};
        self.rotationObjeto7.node = rotationNodeObjeto7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto7#minRot"));
        self.rotationObjeto7.minRot = {};
        self.rotationObjeto7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto7#maxRot"));
        self.rotationObjeto7.maxRot = {};
        self.rotationObjeto7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto7#rotTime"), 2)*1000;
        self.rotationObjeto7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto7#touchRotLimit"), 10));
    end;
	
	local rotationNodeObjeto8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto8#index"));
    if rotationNodeObjeto8 ~= nil then
        self.rotationObjeto8 = {};
        self.rotationObjeto8.node = rotationNodeObjeto8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto8#minRot"));
        self.rotationObjeto8.minRot = {};
        self.rotationObjeto8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto8#maxRot"));
        self.rotationObjeto8.maxRot = {};
        self.rotationObjeto8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto8#rotTime"), 2)*1000;
        self.rotationObjeto8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto8#touchRotLimit"), 10));
    end;	

	local rotationNodeObjeto9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto9#index"));
    if rotationNodeObjeto9 ~= nil then
        self.rotationObjeto9 = {};
        self.rotationObjeto9.node = rotationNodeObjeto9;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto9#minRot"));
        self.rotationObjeto9.minRot = {};
        self.rotationObjeto9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto9#maxRot"));
        self.rotationObjeto9.maxRot = {};
        self.rotationObjeto9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto9#rotTime"), 2)*1000;
        self.rotationObjeto9.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto9#touchRotLimit"), 10));
    end;
	
	local rotationNodeObjeto10 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationObjeto10#index"));
    if rotationNodeObjeto10 ~= nil then
        self.rotationObjeto10 = {};
        self.rotationObjeto10.node = rotationNodeObjeto10;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto10#minRot"));
        self.rotationObjeto10.minRot = {};
        self.rotationObjeto10.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto10.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto10.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationObjeto10#maxRot"));
        self.rotationObjeto10.maxRot = {};
        self.rotationObjeto10.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationObjeto10.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationObjeto10.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationObjeto10.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto10#rotTime"), 2)*1000;
        self.rotationObjeto10.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationObjeto10#touchRotLimit"), 10));
    end;


	self.Objeto1 = false;
	self.Objeto2 = false;
	self.Objeto3 = false;
	self.Objeto4 = false;
	self.Objeto5 = false;
	self.Objeto6 = false;
	self.Objeto7 = false;
	self.Objeto8 = false;
	self.Objeto9 = false;
    self.Objeto10 = false;
end;

function PartesMoveis:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
end;

function PartesMoveis:getSaveAttributesAndNodes(nodeIdent)
end;


function PartesMoveis:delete()
end;

function PartesMoveis:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PartesMoveis:keyEvent(unicode, sym, modifier, isDown)

		if isDown and sym == self.keys.Objeto1 then
			self.Objeto1 = not self.Objeto1;
		end;
		
		if isDown and sym == self.keys.Objeto2 then
			self.Objeto2 = not self.Objeto2;
		end;
	
		if isDown and sym == self.keys.Objeto3 then
			self.Objeto3 = not self.Objeto3;
		end;
		
		if isDown and sym == self.keys.Objeto4 then
			self.Objeto4 = not self.Objeto4;
		end;
		
		if isDown and sym == self.keys.Objeto5 then
			self.Objeto5 = not self.Objeto5;
		end;

		if isDown and sym == self.keys.Objeto6 then
			self.Objeto6 = not self.Objeto6;
		end;
		
		if isDown and sym == self.keys.Objeto7 then
			self.Objeto7 = not self.Objeto7;
		end;
		
		if isDown and sym == self.keys.Objeto8 then
			self.Objeto8 = not self.Objeto8;
		end;
		
		if isDown and sym == self.keys.Objeto9 then
			self.Objeto9 = not self.Objeto9;
		end;
		if isDown and sym == self.keys.Objeto10 then
			self.Objeto10 = not self.Objeto10;
		end;
end;

function PartesMoveis:update(dt)

	if self.isMotorStarted then
		for _, rollNode in pairs(self.rollNodes) do
		rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
		end;
	end;
	
	if self.isThreshing then
		for _, roll1Node in pairs(self.roll1Nodes) do
		rotate(roll1Node.node, -dt*roll1Node.speed, 0, 0);
		end;
	end;

	-- Movements --
		-- Objeto1 --
	local doRotate = self.rotationObjeto1Max or self.rotationObjeto1Min 
	if self.rotationObjeto1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto1.maxRot, self.rotationObjeto1.minRot, 3, self.rotationObjeto1.rotTime, dt, not self.rotationObjeto1Max);
        setRotation(self.rotationObjeto1.node, unpack(newRot));
    end;
		
	if self.Objeto1 then
		self.rotationObjeto1Max = true;
		self.rotationObjeto1Min = false;
	else
		self.rotationObjeto1Max = false;
		self.rotationObjeto1Min = true;
	end;
	
		-- Objeto2 --
	local doRotate = self.rotationObjeto2Max or self.rotationObjeto2Min 
	if self.rotationObjeto2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto2.maxRot, self.rotationObjeto2.minRot, 3, self.rotationObjeto2.rotTime, dt, not self.rotationObjeto2Max);
        setRotation(self.rotationObjeto2.node, unpack(newRot));
    end;
		
	if self.Objeto2 then
		self.rotationObjeto2Max = true;
		self.rotationObjeto2Min = false;
	else
		self.rotationObjeto2Max = false;
		self.rotationObjeto2Min = true;
	end;
	
		-- Objeto3 --
	local doRotate = self.rotationObjeto3Max or self.rotationObjeto3Min 
	if self.rotationObjeto3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto3.maxRot, self.rotationObjeto3.minRot, 3, self.rotationObjeto3.rotTime, dt, not self.rotationObjeto3Max);
        setRotation(self.rotationObjeto3.node, unpack(newRot));
    end;
		
	if self.Objeto3 then
		self.rotationObjeto3Max = true;
		self.rotationObjeto3Min = false;
	else
		self.rotationObjeto3Max = false;
		self.rotationObjeto3Min = true;
	end;
	
		-- Objeto4 --
	local doRotate = self.rotationObjeto4Max or self.rotationObjeto4Min 
	if self.rotationObjeto4 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto4.maxRot, self.rotationObjeto4.minRot, 3, self.rotationObjeto4.rotTime, dt, not self.rotationObjeto4Max);
        setRotation(self.rotationObjeto4.node, unpack(newRot));
    end;
		
	if self.Objeto4 then
		self.rotationObjeto4Max = true;
		self.rotationObjeto4Min = false;
	else
		self.rotationObjeto4Max = false;
		self.rotationObjeto4Min = true;
	end;
	
		-- Objeto5 --
	local doRotate = self.rotationObjeto5Max or self.rotationObjeto5Min 
	if self.rotationObjeto5 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto5.maxRot, self.rotationObjeto5.minRot, 3, self.rotationObjeto5.rotTime, dt, not self.rotationObjeto5Max);
        setRotation(self.rotationObjeto5.node, unpack(newRot));
    end;
		
	if self.Objeto5 then
		self.rotationObjeto5Max = true;
		self.rotationObjeto5Min = false;
	else
		self.rotationObjeto5Max = false;
		self.rotationObjeto5Min = true;
	end;
	
		-- Objeto6 --
	local doRotate = self.rotationObjeto6Max or self.rotationObjeto6Min 
	if self.rotationObjeto6 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto6.maxRot, self.rotationObjeto6.minRot, 3, self.rotationObjeto6.rotTime, dt, not self.rotationObjeto6Max);
        setRotation(self.rotationObjeto6.node, unpack(newRot));
    end;
		
	if self.Objeto6 then
		self.rotationObjeto6Max = true;
		self.rotationObjeto6Min = false;
	else
		self.rotationObjeto6Max = false;
		self.rotationObjeto6Min = true;
	end;
	
		-- Objeto7 --
	local doRotate = self.rotationObjeto7Max or self.rotationObjeto7Min 
	if self.rotationObjeto7 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto7.maxRot, self.rotationObjeto7.minRot, 3, self.rotationObjeto7.rotTime, dt, not self.rotationObjeto7Max);
        setRotation(self.rotationObjeto7.node, unpack(newRot));
    end;
		
	if self.Objeto7 then
		self.rotationObjeto7Max = true;
		self.rotationObjeto7Min = false;
	else
		self.rotationObjeto7Max = false;
		self.rotationObjeto7Min = true;
	end;
	
		-- Objeto8 --
	local doRotate = self.rotationObjeto8Max or self.rotationObjeto8Min 
	if self.rotationObjeto8 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto8.maxRot, self.rotationObjeto8.minRot, 3, self.rotationObjeto8.rotTime, dt, not self.rotationObjeto8Max);
        setRotation(self.rotationObjeto8.node, unpack(newRot));
    end;
		
	if self.Objeto8 then
		self.rotationObjeto8Max = true;
		self.rotationObjeto8Min = false;
	else
		self.rotationObjeto8Max = false;
		self.rotationObjeto8Min = true;
	end;
	
		-- Objeto9 --
	local doRotate = self.rotationObjeto9Max or self.rotationObjeto9Min 
	if self.rotationObjeto9 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto9.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto9.maxRot, self.rotationObjeto9.minRot, 3, self.rotationObjeto9.rotTime, dt, not self.rotationObjeto9Max);
        setRotation(self.rotationObjeto9.node, unpack(newRot));
    end;
		
	if self.Objeto9 then
		self.rotationObjeto9Max = true;
		self.rotationObjeto9Min = false;
	else
		self.rotationObjeto9Max = false;
		self.rotationObjeto9Min = true;
	end;
	-- Objeto10 --
	local doRotate = self.rotationObjeto10Max or self.rotationObjeto10Min 
	if self.rotationObjeto10 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationObjeto10.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationObjeto10.maxRot, self.rotationObjeto10.minRot, 3, self.rotationObjeto10.rotTime, dt, not self.rotationObjeto10Max);
        setRotation(self.rotationObjeto10.node, unpack(newRot));
    end;
		
	if self.Objeto10 then
		self.rotationObjeto10Max = true;
		self.rotationObjeto10Min = false;
	else
		self.rotationObjeto10Max = false;
		self.rotationObjeto10Min = true;
	end;
end;

function PartesMoveis:onLeave()
end;

function PartesMoveis:onEnter()
end;

function PartesMoveis:draw()

end;


function PartesMoveis:onDeactivateSounds()
 
end;

function PartesMoveis:setGrainTankFillLevel(fillLevel, fruitType)
end;
