--
-- rpmLimiterFA3350AL
-- Specialization for a rpm limiter
--
-- @author  Templaer
-- @date  01/05/09
--

rpmLimiterFA3350AL = {};

function rpmLimiterFA3350AL.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function rpmLimiterFA3350AL:load(xmlFile)
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 2100);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 2100);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 2100);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
end;

function rpmLimiterFA3350AL:delete()
end;

function rpmLimiterFA3350AL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rpmLimiterFA3350AL:keyEvent(unicode, sym, modifier, isDown)
end;

function rpmLimiterFA3350AL:update(dt)
    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if Input.isKeyPressed(Input.KEY_m) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif Input.isKeyPressed(Input.KEY_n) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            if Input.isKeyPressed(Input.KEY_m) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif Input.isKeyPressed(Input.KEY_n) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
			
	    end;
		
	end;
end;

function rpmLimiterFA3350AL:draw()
    if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
			--g_currentMission:addExtraPrintText(string.format("Taste %s/%s: %d RPM", InputBinding.getButtonKeyName(InputBinding.ACCELERATE), InputBinding.getButtonKeyName(InputBinding.DECELERATE), self.motor.maxRpm[self.motor.speedLevel]));
            g_currentMission:addExtraPrintText("Tasti M/N:   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	    else
			--g_currentMission:addExtraPrintText(string.format("Taste %s/%s: %d RPM", InputBinding.getButtonKeyName(InputBinding.ACCELERATE), InputBinding.getButtonKeyName(InputBinding.DECELERATE), self.motor.maxRpm[3]));
            g_currentMission:addExtraPrintText("Tasti M/N:   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	    end;
	end;
end;

