manualIgnitionFA3350ALStatsEvent = {};
manualIgnitionFA3350ALStatsEvent_mt = Class(manualIgnitionFA3350ALStatsEvent, Event);

InitEventClass(manualIgnitionFA3350ALStatsEvent, "manualIgnitionFA3350ALStatsEvent");

function manualIgnitionFA3350ALStatsEvent:emptyNew()
    local self = Event:new(manualIgnitionFA3350ALStatsEvent_mt);
    self.className="manualIgnitionFA3350ALStatsEvent";
    return self;
end;

function manualIgnitionFA3350ALStatsEvent:new(vehicle)
    local self = manualIgnitionFA3350ALStatsEvent:emptyNew()
    self.vehicle = vehicle;
    return self;
end;

function manualIgnitionFA3350ALStatsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.vehicle.fuelConsumption = streamReadFloat32(streamId);
	self.vehicle.distanceDriven = streamReadFloat32(streamId);
	self.vehicle.fuelUsed = streamReadFloat32(streamId);
	self.vehicle.runningTime = streamReadFloat32(streamId);
	if not connection:getIsServer() then
		g_server:broadcastEvent(manualIgnitionFA3350ALStatsEvent:new(self.vehicle), nil, connection, self.vehicle);
	end;
end;

function manualIgnitionFA3350ALStatsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.vehicle.fuelConsumption);
	streamWriteFloat32(streamId, self.vehicle.distanceDriven);
	streamWriteFloat32(streamId, self.vehicle.fuelUsed);
	streamWriteFloat32(streamId, self.vehicle.runningTime);
end;

function manualIgnitionFA3350ALStatsEvent.sendEvent(vehicle, isTransport)
	if g_server ~= nil then
		g_server:broadcastEvent(manualIgnitionFA3350ALStatsEvent:new(vehicle), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(manualIgnitionFA3350ALStatsEvent:new(vehicle));
	end;
end;

