manualIgnitionFA3350ALEvent = {};
manualIgnitionFA3350ALEvent_mt = Class(manualIgnitionFA3350ALEvent, Event);

InitEventClass(manualIgnitionFA3350ALEvent, "manualIgnitionFA3350ALEvent");

function manualIgnitionFA3350ALEvent:emptyNew()
    local self = Event:new(manualIgnitionFA3350ALEvent_mt);
    self.className="manualIgnitionFA3350ALEvent";
    return self;
end;

function manualIgnitionFA3350ALEvent:new(object, isRunning)
    local self = manualIgnitionFA3350ALEvent:emptyNew()
    self.object = object;
	self.isRunning = isRunning;
    return self;
end;

function manualIgnitionFA3350ALEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRunning = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function manualIgnitionFA3350ALEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isRunning);
end;

function manualIgnitionFA3350ALEvent:run(connection)
	self.object:invokeIgnition(self.isRunning);
    if not connection:getIsServer() then
        g_server:broadcastEvent(manualIgnitionFA3350ALEvent:new(self.object, self.isRunning), nil, connection, self.object);
    end;	
end;

function manualIgnitionFA3350ALEvent.sendEvent(vehicle, isRunning)
	if g_server ~= nil then
		g_server:broadcastEvent(manualIgnitionFA3350ALEvent:new(vehicle, isRunning), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(manualIgnitionFA3350ALEvent:new(vehicle, isRunning));
	end;
end;

