--
-- manualIgnitionFA3350AL
-- Specialization for manual Motor Ignition
--
-- @author  Templaer
-- @date  01/05/09
--
-- Modifikationen erst nach R�cksprache
-- Do not edit without my permission
--
-- @LS11 multiplayer ready: Andreas Schneider <aksdb@gmx.de> (24.10.2010)

manualIgnitionFA3350AL = {};

function manualIgnitionFA3350AL.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function manualIgnitionFA3350AL:load(xmlFile)
	self.invokeIgnition = SpecializationUtil.callSpecializationsFunction("invokeIgnition");

    -- Booleans
    self.ignitionKey = false;
	self.allowedIgnition = false;  
	
	self.fuelConsumption = 0;
	self.distanceDriven = 0;
	self.fuelUsed = 0;
	self.runningTime = 0;
    local aiMotorSound  = getXMLString(xmlFile, "vehicle.aiMotorSound#file");
    if aiMotorSound  ~= nil and aiMotorSound  ~= "" then
        aiMotorSound  = Utils.getFilename(aiMotorSound, self.baseDirectory);
        self.aiMotorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#pitchOffset"), 0);
        self.aiMotorSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#radius"), 50);
        self.aiMotorSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#innerRadius"), 10);
        self.aiMotorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#volume"), 1);
        self.aiMotorSound = createAudioSource("aiMotorSound", aiMotorSound, self.aiMotorSoundRadius, self.aiMotorSoundInnerRadius, self.aiMotorSoundVolume, 0);
        link(self.components[1].node, self.aiMotorSound);
        setVisibility(self.aiMotorSound, false);
    end;
   
     local aiidleMotorSound  = getXMLString(xmlFile, "vehicle.aiidleMotorSound#file");
      if aiidleMotorSound  ~= nil and aiidleMotorSound  ~= "" then
          aiidleMotorSound  = Utils.getFilename(aiidleMotorSound, self.baseDirectory);
          self.aiidleMotorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiidleMotorSound#pitchOffset"), 0);
          self.aiidleMotorSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiidleMotorSound#radius"), 50);
          self.aiidleMotorSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiidleMotorSound#innerRadius"), 10);
          self.aiidleMotorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiidleMotorSound#volume"), 1);
          self.aiidleMotorSound = createAudioSource("aiidleMotorSound", aiidleMotorSound, self.aiidleMotorSoundRadius, self.aiidleMotorSoundInnerRadius, self.aiidleMotorSoundVolume, 0);
          link(self.components[1].node, self.aiidleMotorSound);
          setVisibility(self.aiidleMotorSound, false);
      end;


   
	
	-- Backup Stop Sound volume
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
	
	self.isMIActor = false;
end;

function manualIgnitionFA3350AL:readStream(streamId, connection)
	self.ignitionKey = streamReadBool(streamId);
	self.isMotorStarted = self.ignitionKey;
	self.steeringEnabled = self.ignitionKey;
	Utils.setEmittingState(self.exhaustParticleSystems, self.ignitionKey);
	setVisibility(self.aiMotorSound, self.ignitionKey);
	
	self.fuelConsumption = streamReadFloat32(streamId);
	self.distanceDriven = streamReadFloat32(streamId);
	self.fuelUsed = streamReadFloat32(streamId);
	self.runningTime = streamReadFloat32(streamId);
end;

function manualIgnitionFA3350AL:writeStream(streamId, connection)
	streamWriteBool(streamId, self.ignitionKey);
	streamWriteFloat32(streamId, self.fuelConsumption);
	streamWriteFloat32(streamId, self.distanceDriven);
	streamWriteFloat32(streamId, self.fuelUsed);
	streamWriteFloat32(streamId, self.runningTime);
end;

function manualIgnitionFA3350AL:delete()
end;

function manualIgnitionFA3350AL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manualIgnitionFA3350AL:keyEvent(unicode, sym, modifier, isDown)
end;

function manualIgnitionFA3350AL:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local runningTime =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#runningTime"),0);
    self.runningTime = runningTime;
    local distanceDriven =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#distanceDriven"),0);
    self.distanceDriven = distanceDriven;
	local fuelUsed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fuelUsed"), 0);
	self.fuelUsed = fuelUsed;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function manualIgnitionFA3350AL:getSaveAttributesAndNodes(nodeIdent)
    local runningTime = Utils.getNoNil(self.runningTime, 10);
	local distanceDriven = Utils.getNoNil(self.distanceDriven, 10);
	local fuelUsed = Utils.getNoNil(self.fuelUsed, 10);
    local attributes = 'runningTime="'..string.format("%f", runningTime)..'"'..' distanceDriven="'..string.format("%f", distanceDriven)..'"'..' fuelUsed="'..string.format("%f", fuelUsed)..'"';
    return attributes, nil;
end;

function manualIgnitionFA3350AL:update(dt)
    acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
    if InputBinding.isAxisZero(acceleration) then
        acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
    end;

	if self.isMotorStarted then
	    local kmMs = self.lastSpeed*self.speedDisplayScale / 1000;
		self.distanceDriven = self.distanceDriven + (kmMs * dt);
	    self.runningTime = self.runningTime + (dt / 1000 / 60 / 60);
		self.fuelConsumption = (self.lastMovedDistance*self.fuelUsage / dt) * 1000 * 60 * 60;
		self.fuelUsed = self.fuelUsed + self.lastMovedDistance*self.fuelUsage;
	end;
	
	-- Does not execute when AI is activated
    if not self.isAITractorActivated then
        -- Handles ignition key input
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.StartEngine) then
		        self.ignitionKey = not self.ignitionKey;
			    self.allowedIgnition = true;
	        end;
			
			-- Turn on the engine when pressing the accelerator
			if math.abs(acceleration) > 0.3 and self.isMotorStarted == false then
			    self.ignitionKey = true;
				self.allowedIgnition = true;
			end;
	    end;
		
	    -- Mutes stop sound when engine is off
	    if not self.ignitionKey or not self.deactivateOnLeave then
	        self.motorStopSoundVolume = 0;
            
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
            
	    end;
								
        if self.ignitionKey and self.allowedIgnition then	
			manualIgnitionFA3350ALEvent.sendEvent(self, true);
		    self:startMotor();
			self.allowedIgnition = false;
			self.deactivateOnLeave = false;
			self.steeringEnabled = true;
			Utils.setEmittingState(self.exhaustParticleSystems, true);
		elseif not self.ignitionKey and self.allowedIgnition then
			manualIgnitionFA3350ALEvent.sendEvent(self, false);
		    if self.motorStopSoundVolume == 0 then
			    self.motorStopSoundVolume = self.motorStopSoundVolume2;
			end;
			
			self:stopMotor();
			self.allowedIgnition = false;
	        self.steeringEnabled = false;
			self.deactivateOnLeave = true;
			setVisibility(self.aiidleMotorSound, false);
			
			-- Brakes the wheels upon turning off the engine
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
			end;
		
		end;
		
    -- Prevents the AI from working when engine is off
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;
end;

function manualIgnitionFA3350AL:onLeave()
    if not self.deactivateOnLeave then
	    Utils.setEmittingState(self.exhaustParticleSystems, true)
		self.allowedIgnition = false;
		self.isMotorStarted = true;
		self.ignitionKey = true; 
		self.steeringEnabled = false;
		setVisibility(self.aiidleMotorSound, true);
		
		-- Brakes the wheels upon turning off the engine
		for k,wheel in pairs(self.wheels) do
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		end;
	else
		self.allowedIgnition = false;
		self.isMotorStarted = false;
		self.ignitionKey = false;
	end;
	
	if self.isMIActor then
		-- Update the stats for other clients (who could possibly enter the vehicle now)
		manualIgnitionFA3350ALStatsEvent.sendEvent(self);
		self.isMIActor = false;
	end;
end;

function manualIgnitionFA3350AL:onEnter()
	self.isMIActor = self.isEntered;

	-- Prevents the engine from starting upon entering
	if not self.ignitionKey then
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false);
	else
	    self.steeringEnabled = true;
	end;
	
	if self.isEntered then
		setVisibility(self.aiidleMotorSound, false);
	else
		setVisibility(self.aiidleMotorSound, self.ignitionKey);
	end;
end;

function manualIgnitionFA3350AL:draw()
	if not self.isAITractorActivated then
		if self.isEntered and self.allowedIgnition and self.ignitionKey then
			g_currentMission:addHelpButtonText(g_i18n:getText("StartEngine"), InputBinding.StartEngine);
		end;
	end;
end;

function manualIgnitionFA3350AL:invokeIgnition(isRunning)
	if self.ignitionKey ~= isRunning then
		self.ignitionKey = isRunning;
		if isRunning then
			self:startMotor();
			self.allowedIgnition = false;
			self.deactivateOnLeave = false;
			self.steeringEnabled = true;
			Utils.setEmittingState(self.exhaustParticleSystems, true);
			setVisibility(self.aiidleMotor, true);
		else
			self:stopMotor();
			self.allowedIgnition = false;
			self.steeringEnabled = false;
			self.deactivateOnLeave = true;
			setVisibility(self.aiidleMotor, false);
		end;
	end;
end;