--
-- Copyright  2014 Joacim Sigfridsson <joxxer@msn.com>
-- This work is free. You can redistribute it and/or modify it under the
-- terms of the Do What The Fuck You Want To Public License, Version 2,
-- as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
--
--
-- NewHollandTM150
-- Specialization for NewHollandTM150 mod
--
-- @author  	JoXXer
-- @date  		28/12/13
--

NewHollandTM150 = {};

function NewHollandTM150.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function NewHollandTM150:load(xmlFile)
	self.setRearLinkageRaised = SpecializationUtil.callSpecializationsFunction("setRearLinkageRaised");
	
	self.beaconRotatingParts = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.beaconLights.beaconLight(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#rotatingPart"));
		if node ~= nil then
			table.insert(self.beaconRotatingParts, node);
		end;
		i = i + 1;
	end;
	
	self.frontLinkage = {};
	
	self.frontLinkage.arms = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkage#arms"));
	self.frontLinkage.topLink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkage#topLink"));
	setVisibility(self.frontLinkage.topLink, false);
	-- heh, balls
	self.frontLinkage.balls = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkage#linkageBalls"));
	self.frontLinkage.transportRot = math.rad(Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontLinkage#transportRot"), 0));
	
	if self.frontLinkage.arms ~= nil then
		self.frontLinkage.armsOrigRot = {getRotation(self.frontLinkage.arms)};
		local x, y, z = unpack(self.frontLinkage.armsOrigRot);
		setRotation(self.frontLinkage.arms, self.frontLinkage.transportRot, y, z);
	end;
	
	if self.frontLinkage.balls ~= nil then
		setVisibility(self.frontLinkage.balls, false);
	end;
	
	self.rearLinkageBalls = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearLinkageBalls#index"));
	
	if self.rearLinkageBalls ~= nil then
		setVisibility(self.rearLinkageBalls, false);
	end;
	
	self.lowTrailerAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherParts#lowAttacher"));
	
	self.topAttacherPin = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherParts#topPin"));
	if self.topAttacherPin then
		setVisibility(self.topAttacherPin, false);
	end;
	self.lowAttacherPin = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherParts#lowPin"));
	if self.lowAttacherPin then
		setVisibility(self.lowAttacherPin, false);
	end;
	
	self.rearLinkageJointIndex = 1;
	self.raiseRearLinkage = 0;
	self.isRearLinkageUp = false;
	
	self.implementNoLowering = false;
	
	self.steeringColumn = {};
	self.steeringColumn.anim = getXMLString(xmlFile, "vehicle.steeringColumn#animName");
	self.steeringColumn.speed = getXMLFloat(xmlFile, "vehicle.steeringColumn#speed");
	
	self.moveDownIntervall = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.moveDownIntervall#ms"), 1000);
	self.updateJoint = false;
	self.doLowering = false;
	self.loweringDone = false;
	self.nextAction = false;
	self.delay = 0;
	self.implementCount = 0;
end;

function NewHollandTM150:delete()
end;

function NewHollandTM150:readStream(streamId, connection)
	self:setRearLinkageRaised(streamReadInt8(streamId), true);
end;

function NewHollandTM150:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.raiseRearLinkage);
end;

function NewHollandTM150:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NewHollandTM150:keyEvent(unicode, sym, modifier, isDown)
end;

function NewHollandTM150:update(dt)
	if self:getIsActive() then
		if self.beaconLightsActive then
			for int, beaconLight in pairs(self.beaconLights) do
				local x, y, z = getRotation(beaconLight.node);
				setRotation(self.beaconRotatingParts[int], x, y, z);
			end;
		end;
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.TOGGLE_REAR_LINKAGE) then
				if self.isRearLinkageUp then
					self:setRearLinkageRaised(-1);
				else
					self:setRearLinkageRaised(1);
				end;
			end;
			if InputBinding.hasEvent(InputBinding.LOWER_ALL_IMPLEMENTS) then
				if self.implementCount == 2 then			
					self.loweringDone = false;
					self.delay = self.moveDownIntervall;
					self.doLowering = true;
					self.nextAction = not self.attacherJoints[1].moveDown;
					if self.attacherJoints[2].moveDown ~= not self.nextAction then 
						self.nextAction = false;
					end;
				end;
			end;		
		end;
	end;
	
	-- Make parts move, magic
	for _, part in pairs(self.movingParts) do
		Cylindered.setDirty(self, part);
	end;
end;

function NewHollandTM150:updateTick(dt)
	if self:getIsActive() then	
		if self.doLowering then	
			local back = self.attacherJoints[1];
			local front = self.attacherJoints[2];	
			if not self.loweringDone then
				self:setJointMoveDown(2, self.nextAction);
				self.loweringDone = true;
			end;			
			if self.loweringDone then
				self.delay = self.delay - dt;				
				if self.delay <= 0 then
					self:setJointMoveDown(1, self.nextAction);
					self.doLowering = false;
				end;
			end;
		end;
		
		if self.raiseRearLinkage ~= 0 and self.isClient then
			local x, y, z = getRotation(self.attacherJoints[self.rearLinkageJointIndex].rotationNode);
			local x2, y2, z2 = getRotation(self.attacherJoints[self.rearLinkageJointIndex].rotationNode2);
			if self.raiseRearLinkage > 0 then
				if x < math.rad(15) then
					setRotation(self.attacherJoints[self.rearLinkageJointIndex].rotationNode, x + (0.0005 * dt), 0, 0);
					if x2 > math.rad(-15) then
						setRotation(self.attacherJoints[self.rearLinkageJointIndex].rotationNode2, x2 - (0.0005 * dt), 0, 0);
					end;
					self.updateJoint = true;
				else
					self:setRearLinkageRaised(0);
				end;
			elseif self.raiseRearLinkage < 0 then
				if x > math.rad(-15) then
					setRotation(self.attacherJoints[self.rearLinkageJointIndex].rotationNode, x - (0.0005 * dt), 0, 0);
					if x2 < math.rad(15) then
						setRotation(self.attacherJoints[self.rearLinkageJointIndex].rotationNode2, x2 + (0.0005 * dt), 0, 0);
					end;
					self.updateJoint = true;
				else
					self:setRearLinkageRaised(0);
				end;
			end;
		end;
	end;
end;

function NewHollandTM150:draw()	
	if self.implementNoLowering then
		if self.isRearLinkageUp then
			g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_REAR_LINKAGE"), InputBinding.TOGGLE_REAR_LINKAGE);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("RAISE_REAR_LINKAGE"), InputBinding.TOGGLE_REAR_LINKAGE);
		end;
	end; 
	
	if self.implementNoLowering and self.implementCount == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_FRONT_IMPLEMENT"), InputBinding.LOWER_ALL_IMPLEMENTS);
	elseif self.implementCount == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_ALL_IMPLEMENTS"), InputBinding.LOWER_ALL_IMPLEMENTS);
	end;
end;

function NewHollandTM150:onLeave()
	self:playAnimation(self.steeringColumn.anim, -self.steeringColumn.speed, Utils.clamp(self:getAnimationTime(self.steeringColumn.anim), 0, 1), true);
end;

function NewHollandTM150:onEnter()
	self:playAnimation(self.steeringColumn.anim, self.steeringColumn.speed, Utils.clamp(self:getAnimationTime(self.steeringColumn.anim), 0, 1), true);
end;

function NewHollandTM150:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;
		if jointIndex == 1 then
			setVisibility(self.rearLinkageBalls, true);
			setVisibility(self.lowTrailerAttacher, false);
			if not implement.object.allowsLowering then
				self.implementNoLowering = true;
			end;
		elseif jointIndex == 2 then
			if self.frontLinkage.arms ~= nil then
				setRotation(self.frontLinkage.arms, unpack(self.frontLinkage.armsOrigRot));
			end;
			if self.frontLinkage.balls ~= nil then
				setVisibility(self.frontLinkage.balls, true);
			end;
			if self.frontLinkage.topLink ~= nil then
				setVisibility(self.frontLinkage.topLink, true);
			end;
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 4 then
			if self.topAttacherPin then
				setVisibility(self.topAttacherPin, true);
			end;
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 5 then
			if self.lowAttacherPin then
				setVisibility(self.lowAttacherPin, true);
			end;
		end;
	end;

	self.updateJoint = true;
end;

function NewHollandTM150:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
		if jointIndex == 1 then
			setVisibility(self.rearLinkageBalls, false);
			setVisibility(self.lowTrailerAttacher, true);
			self.implementNoLowering = false;
		elseif jointIndex == 2 then
			if self.frontLinkage.arms ~= nil then
				local x, y, z = unpack(self.frontLinkage.armsOrigRot);
				setRotation(self.frontLinkage.arms, self.frontLinkage.transportRot, y, z);
			end;
			if self.frontLinkage.balls ~= nil then
				setVisibility(self.frontLinkage.balls, false);
			end;
			if self.frontLinkage.topLink ~= nil then
				setVisibility(self.frontLinkage.topLink, false);
			end;
		end;
	elseif implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 4 then
			if self.topAttacherPin then
				setVisibility(self.topAttacherPin, false);
			end;
		end;
	elseif implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 5 then
			if self.lowAttacherPin then
				setVisibility(self.lowAttacherPin, false);
			end;
		end;
	end;
end;

function NewHollandTM150:validateAttacherJoint(implement, jointDesc, dt)
	if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;

function NewHollandTM150:setRearLinkageRaised(raiseRearLinkage, noEventSend)
	RaiseRearLinkageEvent.sendEvent(self, raiseRearLinkage, noEventSend);
	
	if raiseRearLinkage > 0 then
		self.isRearLinkageUp = true;
	elseif raiseRearLinkage < 0 then
		self.isRearLinkageUp = false;
	end;
	
	self.raiseRearLinkage = raiseRearLinkage;
end;

-- Events
-- RaiseRearLinkageEvent

RaiseRearLinkageEvent = {};
RaiseRearLinkageEvent_mt = Class(RaiseRearLinkageEvent, Event);

InitEventClass(RaiseRearLinkageEvent, "RaiseRearLinkageEvent");

function RaiseRearLinkageEvent:emptyNew()
    local self = Event:new(RaiseRearLinkageEvent_mt);
    return self;
end;

function RaiseRearLinkageEvent:new(vehicle, raiseRearLinkage)
    local self = RaiseRearLinkageEvent:emptyNew()
    self.vehicle = vehicle;
	self.level = raiseRearLinkage;
    return self;
end;

function RaiseRearLinkageEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.raiseRearLinkage = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function RaiseRearLinkageEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamReadInt8(streamId, self.raiseRearLinkage);
end;

function RaiseRearLinkageEvent:run(connection)
	self.vehicle:setRearLinkageRaised(self.raiseRearLinkage, true);
end;

function RaiseRearLinkageEvent.sendEvent(vehicle, raiseRearLinkage, noEventSend)
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RaiseRearLinkageEvent:new(vehicle, raiseRearLinkage), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RaiseRearLinkageEvent:new(vehicle, raiseRearLinkage));
		end;
	end;
end;