--
-- Copyright ? 2014 Joacim Sigfridsson <joxxer@msn.com>
-- This work is free. You can redistribute it and/or modify it under the
-- terms of the Do What The Fuck You Want To Public License, Version 2,
-- as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
--
--
-- BJR_DashboardIndicators
-- Specialization for BJR_DashboardIndicators 
--
-- @author  	JoXXer
-- @date  		26/01/14
--
-- @history	v1.0 - Initial implementation
--
--

BJR_DashboardIndicators = {};

function BJR_DashboardIndicators.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function BJR_DashboardIndicators:load(xmlFile)

	self.RPMDigits = SpecializationUtil.callSpecializationsFunction("RPMDigits");
	self.updateFuelIndicators = SpecializationUtil.callSpecializationsFunction("updateFuelIndicators");

	-- Moving parts
	-- Switches
	self.numSwitches = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.switches#count"),0);
	self.switch = {};
	for i=1, self.numSwitches do
		local objname = string.format("vehicle.switches.switch" .. "%d", i);
		self.switch[i] = {};
		self.switch[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
	end;

	-- PTO
	self.PTOKnob = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PTOKnob#index"));
	if self.PTOKnob ~= nil then
		self.PTOKnobStartTrans = {getTranslation(self.PTOKnob)};
	end;
	self.PTOOnLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PTOOnLight#index"));

	-- Dashboard indicators
	self.dashboardOil = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardOil#index"));
	setVisibility(self.dashboardOil,false);
	self.dashboardFuel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardFuel#index"));
	setVisibility(self.dashboardFuel,false);
	self.dashboard4WD = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboard4WD#index"));
	setVisibility(self.dashboard4WD,false);
	self.dashboardParkingBrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardParkingBrake#index"));
	setVisibility(self.dashboardParkingBrake,false);
	self.dashboardSlow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardSlow#index"));
	setVisibility(self.dashboardSlow,false);
	self.dashboardFast = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardFast#index"));
	setVisibility(self.dashboardFast,false);
	self.dashboardBattery = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardBattery#index"));
	setVisibility(self.dashboardBattery,false);
	self.dashboardEngineThing1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardEngineThing1#index"));
	setVisibility(self.dashboardEngineThing1,false);
	self.dashboardEngineThing2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardEngineThing2#index"));
	setVisibility(self.dashboardEngineThing2,false);
	self.blankDisplays = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blankDisplays#index"));
	setVisibility(self.blankDisplays,false);

	self.digitRPMs = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.digitRPMs#index"));
	self.digitRPMsLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.digitRPMsLight#index"));
	setVisibility(self.digitRPMs,true);
	setVisibility(self.digitRPMsLight,false);

	-- Fuel indicators
	self.fuelIndicatorsGroup = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fuelIndicators#index"));

	self.numFuelIndicators = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fuelIndicators#count"), 0);
	self.fuelIndicators = {};
    for i=1, self.numFuelIndicators do
        local objname = string.format("vehicle.fuelIndicators.fuelIndicator" .. "%d", i);
		self.fuelIndicators[i] = {};
        self.fuelIndicators[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.fuelIndicators[i].rotNode,true);
    end;
	--Fuel indicators light
	self.fuelIndicatorsLightGroup = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fuelIndicatorsLight#index"));

	self.numFuelIndicatorsLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fuelIndicatorsLight#count"), 0);
	self.fuelIndicatorsLight = {};
    for i=1, self.numFuelIndicatorsLight do
        local objname = string.format("vehicle.fuelIndicatorsLight.fuelIndicator" .. "%d", i);
		self.fuelIndicatorsLight[i] = {};
        self.fuelIndicatorsLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.fuelIndicatorsLight[i].rotNode,true);
    end;
	setVisibility(self.fuelIndicatorsLightGroup, false);

	-- Digital Display digits RPM
	self.numDigitRPMOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMOne#count"), 0);
	self.digitRPMOne = {};
    for i=1, self.numDigitRPMOne do
        local objname = string.format("vehicle.displayDigitRPMOne.digitRPM" .. "%d", i);
		self.digitRPMOne[i] = {};
        self.digitRPMOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.digitRPMOne[i].rotNode,false);
    end;
	setVisibility(self.digitRPMOne[self.numDigitRPMOne].rotNode,true);

	self.numDigitRPMTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMTwo#count"), 0);
	self.digitRPMTwo = {};
    for i=1, self.numDigitRPMTwo do
        local objname = string.format("vehicle.displayDigitRPMTwo.digitRPM" .. "%d", i);
		self.digitRPMTwo[i] = {};
        self.digitRPMTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.digitRPMTwo[i].rotNode,false);
    end;
	setVisibility(self.digitRPMTwo[self.numDigitRPMTwo].rotNode,true);

	self.numDigitRPMThree = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMThree#count"), 0);
	self.digitRPMThree = {};
    for i=1, self.numDigitRPMThree do
        local objname = string.format("vehicle.displayDigitRPMThree.digitRPM" .. "%d", i);
		self.digitRPMThree[i] = {};
        self.digitRPMThree[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.digitRPMThree[i].rotNode,false);
    end;
	setVisibility(self.digitRPMThree[self.numDigitRPMThree].rotNode,true);

	self.numDigitRPMFour = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMFour#count"), 0);
	self.digitRPMFour = {};
    for i=1, self.numDigitRPMFour do
        local objname = string.format("vehicle.displayDigitRPMFour.digitRPM" .. "%d", i);
		self.digitRPMFour[i] = {};
        self.digitRPMFour[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.digitRPMFour[i].rotNode,false);
    end;
	setVisibility(self.digitRPMFour[self.numDigitRPMFour].rotNode,true);

	-- Digital display ligth on
	-- Digital Display digits RPM
	self.numDigitRPMOneLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMOneLight#count"), 0);
	self.digitRPMOneLight = {};
    for i=1, self.numDigitRPMOneLight do
        local objname = string.format("vehicle.displayDigitRPMOneLight.digitRPM" .. "%d", i);
		self.digitRPMOneLight[i] = {};
        self.digitRPMOneLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.digitRPMOneLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMOneLight[self.numDigitRPMOneLight].rotNode,true);

	self.numDigitRPMTwoLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMTwoLight#count"), 0);
	self.digitRPMTwoLight = {};
    for i=1, self.numDigitRPMTwoLight do
        local objname = string.format("vehicle.displayDigitRPMTwoLight.digitRPM" .. "%d", i);
		self.digitRPMTwoLight[i] = {};
        self.digitRPMTwoLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.digitRPMTwoLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMTwoLight[self.numDigitRPMTwoLight].rotNode,true);

	self.numDigitRPMThreeLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMThreeLight#count"), 0);
	self.digitRPMThreeLight = {};
    for i=1, self.numDigitRPMThreeLight do
        local objname = string.format("vehicle.displayDigitRPMThreeLight.digitRPM" .. "%d", i);
		self.digitRPMThreeLight[i] = {};
        self.digitRPMThreeLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.digitRPMThreeLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMThreeLight[self.numDigitRPMThreeLight].rotNode,true);

	self.numDigitRPMFourLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMFourLight#count"), 0);
	self.digitRPMFourLight = {};
    for i=1, self.numDigitRPMFourLight do
        local objname = string.format("vehicle.displayDigitRPMFourLight.digitRPM" .. "%d", i);
		self.digitRPMFourLight[i] = {};
        self.digitRPMFourLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
		setVisibility(self.digitRPMFourLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMFourLight[self.numDigitRPMFourLight].rotNode,true);

	-- RPM display
	self.displayValue = 0;
	self.prevousDigitRPMFour = self.numDigitRPMFour;
	self.prevousDigitRPMThree = self.numDigitRPMThree;
	self.prevousDigitRPMTwo = self.numDigitRPMTwo;
	self.prevousDigitRPMOne = 0;

	self.cycleRoundMax = 30;
	self.currentCycle = 0;
	self.lastRpm = 0;
	
	self.oldTimesToIterate = 0;

	self.showSpeed = false;
end;

function BJR_DashboardIndicators:delete()
end;

function BJR_DashboardIndicators:readStream(streamId, connection)
	self.showSpeed = streamReadBool(streamId);
end;

function BJR_DashboardIndicators:writeStream(streamId, connection)
	streamWriteBool(streamId, self.showSpeed);
end;

function BJR_DashboardIndicators:readUpdateStream(streamId, timestamp, connection)
end;

function BJR_DashboardIndicators:writeUpdateStream(streamId, connection, dirtyMask)
end;

function BJR_DashboardIndicators:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BJR_DashboardIndicators:keyEvent(unicode, sym, modifier, isDown)
end;

function BJR_DashboardIndicators:update(dt)

	if self.isEntered then
		self:RPMDigits();
		self:updateFuelIndicators();
	end;
	
end;

function BJR_DashboardIndicators:updateTick(dt)
	if self:getIsActive() then
		if self.isMotorStarted then
			if self.fuelFillLevel < 50 then
				setVisibility(self.dashboardFuel, true);
			else
				setVisibility(self.dashboardFuel, false);
			end;

			if self.is4wdActive then
				setVisibility(self.dashboard4WD, true);
			else
				setVisibility(self.dashboard4WD, false);
			end;

			--[[if self.dashboardFast ~= nil then
				if self.currentFwdGear > 14 then
					setVisibility(self.dashboardFast, true);
				elseif self.currentFwdGear <= 14 then
					setVisibility(self.dashboardFast, false);
				end;
			end;

			if self.dashboardSlow ~= nil then
				if self.currentFwdGear <= 6 then
					setVisibility(self.dashboardSlow, true);
				else
					setVisibility(self.dashboardSlow, false);
				end;
			end;]]

			local mySpeed = self.lastSpeed*3600;
			if self.isBraking and mySpeed > 0 then
				if self.dashboard4WD ~= nil then
					setVisibility(self.dashboard4WD, true);
				end;
			end;

			if self.dashboardParkingBrake ~= nil then
				if self.handbrake then
					setVisibility(self.dashboardParkingBrake, true);
				else
					setVisibility(self.dashboardParkingBrake, false);
				end;
			end;

			if self.realLightsActive then
				setVisibility(self.digitRPMs,false);
				setVisibility(self.digitRPMsLight,true);
				setVisibility(self.fuelIndicatorsGroup, false);
				setVisibility(self.fuelIndicatorsLightGroup, true);
			else
				setVisibility(self.digitRPMs,true);
				setVisibility(self.digitRPMsLight,false);
				setVisibility(self.fuelIndicatorsGroup, true);
				setVisibility(self.fuelIndicatorsLightGroup, false);
			end;

			for k, implement in pairs(self.attachedImplements) do
				if implement.object ~= nil then
					if implement.object.isTurnedOn then
						local x, y, z = unpack(self.PTOKnobStartTrans);
						setTranslation(self.PTOKnob, x, y+0.004, z);
					else
						setTranslation(self.PTOKnob, unpack(self.PTOKnobStartTrans));
						setVisibility(self.PTOOnLight, true);
						setVisibility(self.PTOOnLight, false);
					end;
				end;
			end;
		end;

		if self.ignitionMode == 0 then
			if self.dashboardSlow ~= nil then
				setVisibility(self.dashboardSlow, false);
			end;
			if self.dashboardFast ~= nil then
				setVisibility(self.dashboardFast, false);
			end;
			if self.dashboardParkingBrake ~= nil then
				setVisibility(self.dashboardParkingBrake, false);
			end;
			if self.shuttleIndicatorsIndex ~= nil then
				setVisibility(self.shuttleIndicatorsIndex,false);
			end;
			if self.shuttleIndicatorsLightIndex ~= nil then
				setVisibility(self.shuttleIndicatorsLightIndex,false);
			end;
			if self.gearDigits ~= nil then
				setVisibility(self.gearDigits,false);
			end;
			if self.gearDigitsLight ~= nil then
				setVisibility(self.gearDigitsLight,false);
			end;
			if self.dashboard4WD ~= nil then
				setVisibility(self.dashboard4WD, false);
			end;
			if self.dashboardFuel ~= nil then
				setVisibility(self.dashboardFuel, false);
			end;
			if self.digitRPMs ~= nil then
				setVisibility(self.digitRPMs,false);
			end;
			if self.digitRPMsLight ~= nil then
				setVisibility(self.digitRPMsLight,false);
			end;
			if self.fuelIndicatorsGroup ~= nil then
				setVisibility(self.fuelIndicatorsGroup, false);
			end;
			if self.fuelIndicatorsLightGroup ~= nil then
				setVisibility(self.fuelIndicatorsLightGroup, false);
			end;
			if self.blankDisplays ~= nil then
				setVisibility(self.blankDisplays, true);
			end;
		elseif self.ignitionMode == 1 then
			if self.realLightsActive then
				if self.fuelIndicatorsGroup ~= nil then
					setVisibility(self.fuelIndicatorsGroup, false);
				end;
				if self.fuelIndicatorsLightGroup ~= nil then
					setVisibility(self.fuelIndicatorsLightGroup, true);
				end;
			else
				if self.fuelIndicatorsGroup ~= nil then
					setVisibility(self.fuelIndicatorsGroup, true);
				end;
				if self.fuelIndicatorsLightGroup ~= nil then
					setVisibility(self.fuelIndicatorsLightGroup, false);
				end;
			end;
			if self.blankDisplays ~= nil then
				setVisibility(self.blankDisplays, false);
			end;
			if self.dashboardBattery ~= nil then
				setVisibility(self.dashboardBattery, true);
			end;
			if self.dashboardEngineThing1 ~= nil then
				setVisibility(self.dashboardEngineThing1, true);
			end;
			if self.dashboardEngineThing2 ~= nil then
				setVisibility(self.dashboardEngineThing2, true);
			end;
			if self.dashboardParkingBrake ~= nil then
				setVisibility(self.dashboardParkingBrake, true);
			end;
			if self.dashboardOil ~= nil then
				setVisibility(self.dashboardOil, true);
			end;
			if self.dashboardFuel ~= nil then
				setVisibility(self.dashboardFuel, true);
			end;
		elseif self.ignitionMode == 2 then
			if self.dashboardBattery ~= nil then
				setVisibility(self.dashboardBattery, false);
			end;
			if self.dashboardEngineThing1 ~= nil then
				setVisibility(self.dashboardEngineThing1, false);
			end;
			if self.dashboardEngineThing2 ~= nil then
				setVisibility(self.dashboardEngineThing2, false);
			end;
			if self.dashboardOil ~= nil then
				setVisibility(self.dashboardOil, false);
			end;
			if self.dashboardFuel ~= nil and self.fuelFillLevel > 50 then
				setVisibility(self.dashboardFuel, false);
			end;
		end;
	end;

	-- Switches rotations
	-- Back wiper switch
	if self.switch[1] ~= nil then
		if self.wiperBackOn then
			setRotation(self.switch[1], math.rad(-43.27), math.rad(-11.6), math.rad(-12));
		else
			setRotation(self.switch[1], math.rad(-44.5), 0, 0);
		end;
	end;

	-- Beaconlights switch
	if self.switch[2] ~= nil then
		if self.beaconLightsActive then
			setRotation(self.switch[2], math.rad(-43.27), math.rad(-11.6), math.rad(-12));
			setVisibility(self.beaconSwitchLight, true);
		else
			setRotation(self.switch[2], math.rad(-44.5), 0, 0);
			setVisibility(self.beaconSwitchLight, false);
		end;
	end;

	-- Warninglights switch
	if self.switch[3] ~= nil then
		--[[if self.B3.wl then
			setRotation(self.switch[3], math.rad(-43.27), math.rad(-11.6), math.rad(-12));
		else
			setRotation(self.switch[3], math.rad(-44.5), 0, 0);
		end;]]
	end;
	
	--[[if self.indicatorsLever ~= nil then
		if not self.B3.wl then
			if self.B3.dirRight[1].a then
				setRotation(self.indicatorsLever, 0, math.rad(20), math.rad(180));
			elseif self.B3.dirLeft[1].a then
				setRotation(self.indicatorsLever, 0, math.rad(-20), math.rad(180));
			else
				setRotation(self.indicatorsLever, 0, 0, math.rad(180));
			end;
		else
			setRotation(self.indicatorsLever, 0, 0, math.rad(180));
		end;
	end;]]
end;

function BJR_DashboardIndicators:draw()
end;

function BJR_DashboardIndicators:onLeave()
end;

function BJR_DashboardIndicators:onEnter()
end;

function BJR_DashboardIndicators:RPMDigits()
	-- Digital Display handling RPM
	if self.isEntered then
		if self.isMotorStarted then
			if self.showSpeed then
				local kmh = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600)) - 0.00008 *dt;
				self.displayValue = kmh;
			else
				if self.currentCycle < self.cycleRoundMax then
					self.currentCycle = self.currentCycle + 1;
					self.currentRPM = self.motor.lastMotorRpm;
					if self.rpmMeterValue ~= nil then
						self.currentRPM = self.rpmMeterValue;
					end;
					self.lastRpm = math.floor((self.lastRpm + self.currentRPM)/2);
					if self.lastRpm < 400 then
						self.lastRpm = math.random(380, 420);
					end;
				else
					self.currentCycle = 0;
					self.displayValue = self.lastRpm;
				end;
			end;
		else
			self.displayValue = 0;
		end;

		local displayValue = self.displayValue;
		-- Handle the digitRPMs in the display
		if self.isMotorStarted then
			local thousends = math.floor(displayValue/1000);
			local displayIndex = thousends;
			local isBlank = false;
			if self.prevousDigitRPMFour ~= thousends then
				if self.prevousDigitRPMFour > 0 then
					setVisibility(self.digitRPMFour[self.prevousDigitRPMFour].rotNode,false);
					setVisibility(self.digitRPMFourLight[self.prevousDigitRPMFour].rotNode,false);
				end;
				if displayIndex == 0 then
					isBlank = true;
				end;
				if isBlank then
					for i=1, self.numDigitRPMFour do
						setVisibility(self.digitRPMFour[i].rotNode,false);
						setVisibility(self.digitRPMFourLight[i].rotNode,false);
					end;
				else
					setVisibility(self.digitRPMFour[displayIndex].rotNode,true);
					setVisibility(self.digitRPMFourLight[displayIndex].rotNode,true);
				end;
			end;
			self.prevousDigitRPMFour = displayIndex;

			displayValue = displayValue - thousends * 1000;
			local hundreds = math.floor(displayValue/100);
			displayIndex = hundreds;
			isBlank = false;
			if self.prevousDigitRPMThree ~= hundreds then
				if self.prevousDigitRPMThree > 0 then
					setVisibility(self.digitRPMThree[self.prevousDigitRPMThree].rotNode,false);
					setVisibility(self.digitRPMThreeLight[self.prevousDigitRPMThree].rotNode,false);
				end;
				if displayIndex == 0 and thousends == 0 then
					isBlank = true;
				elseif displayIndex == 0 then
					if thousends > 0 then
						displayIndex = 10;
					end;
				end;
				if isBlank then
					for i=1, self.numDigitRPMThree do
						setVisibility(self.digitRPMThree[i].rotNode,false);
						setVisibility(self.digitRPMThreeLight[i].rotNode,false);
					end;
				else
					setVisibility(self.digitRPMThree[displayIndex].rotNode,true);
					setVisibility(self.digitRPMThreeLight[displayIndex].rotNode,true);
				end;
			end;
			self.prevousDigitRPMThree = displayIndex;

			displayValue = displayValue - hundreds * 100;
			local tens = math.floor(displayValue/10);
			displayIndex = tens;
			isBlank = false;
			if self.prevousDigitRPMTwo ~= tens then
				if self.prevousDigitRPMTwo > 0 then
					setVisibility(self.digitRPMTwo[self.prevousDigitRPMTwo].rotNode,false);
					setVisibility(self.digitRPMTwoLight[self.prevousDigitRPMTwo].rotNode,false);
				end;
				if displayIndex == 0 and hundreds == 0 then
					isBlank = true;
				elseif displayIndex == 0 then
					if hundreds > 0 or thousends > 0 then
						displayIndex = 10;
					end;
				end;
				if isBlank then
					for i=1, self.numDigitRPMTwo do
						setVisibility(self.digitRPMTwo[i].rotNode,false);
						setVisibility(self.digitRPMTwoLight[i].rotNode,false);
					end;
				else
					setVisibility(self.digitRPMTwo[displayIndex].rotNode,true);
					setVisibility(self.digitRPMTwoLight[displayIndex].rotNode,true);
				end;
			end;
			self.prevousDigitRPMTwo = displayIndex;

			displayValue = displayValue - tens * 10;
			local ones = math.floor(displayValue);
			--displayIndex = 10;
			if self.showSpeed then
				if displayValue >= 10 and displayValue < 20 then
					displayIndex = displayValue-10;
				elseif displayValue >= 20 and displayValue < 30 then
					displayIndex = displayValue-20;
				elseif displayValue >= 30 and displayValue < 40 then
					displayIndex = displayValue-30;
				elseif displayValue >= 40 and displayValue < 50 then
					displayIndex = displayValue-40;
				elseif displayValue >= 50 and displayValue < 60 then
					displayIndex = displayValue-50;
				else
					displayIndex = displayValue;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
			end;
			if self.prevousDigitRPMOne ~= ones then
				if self.prevousDigitRPMOne > 0 then
					if (math.floor(displayIndex)+1) ~= 11 then
						setVisibility(self.digitRPMOne[self.prevousDigitRPMOne].rotNode,false);
						setVisibility(self.digitRPMOneLight[self.prevousDigitRPMOne].rotNode,false);
					end;
				end;

				if math.floor(displayIndex) == 0 then
					displayIndex = 10;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
				setVisibility(self.digitRPMOne[math.floor(displayIndex)].rotNode,true);
				setVisibility(self.digitRPMOneLight[math.floor(displayIndex)].rotNode,true);
			end;
			self.prevousDigitRPMOne = math.floor(displayIndex);
			self.rpmDisplaysSetOff = false;
		else
			if not self.rpmDisplaysSetOff then
				for i=1, self.numDigitRPMOne do
					setVisibility(self.digitRPMOne[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMTwo do
					setVisibility(self.digitRPMTwo[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThree do
					setVisibility(self.digitRPMThree[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMFour do
					setVisibility(self.digitRPMFour[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMOneLight do
					setVisibility(self.digitRPMOneLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMTwoLight do
					setVisibility(self.digitRPMTwoLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThreeLight do
					setVisibility(self.digitRPMThreeLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMFourLight do
					setVisibility(self.digitRPMFourLight[i].rotNode,false);
				end;

				self.rpmDisplaysSetOff = true;
			end;
		end;
	end;
end;

function BJR_DashboardIndicators:updateFuelIndicators()
	local amountOfFuelPerIndicator = self.fuelCapacity/12;

	local timesToIterate = self.fuelFillLevel/amountOfFuelPerIndicator;

	timesToIterate = math.floor(timesToIterate);

	if self.oldTimesToIterate ~= timesToIterate then
		for i=1, self.numFuelIndicators do
			setVisibility(self.fuelIndicators[i].rotNode, false);
			setVisibility(self.fuelIndicatorsLight[i].rotNode, false);
		end;

		for i=1, timesToIterate do
			setVisibility(self.fuelIndicators[i].rotNode, true);
			setVisibility(self.fuelIndicatorsLight[i].rotNode, true);
		end;
	end;

	self.oldTimesToIterate = timesToIterate;
end;
