--
-- Copyright  2014 Joacim Sigfridsson <joxxer@msn.com>
-- This work is free. You can redistribute it and/or modify it under the
-- terms of the Do What The Fuck You Want To Public License, Version 2,
-- as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
--
--
-- BJR_BuyableLoaderBrackets
-- Specialization for BJR_BuyableLoaderBrackets
--
-- @author	JoXXer
-- @date	02/01/14
--
-- @history	v1.0 - Initial implementation
--
-- 

BJR_BuyableLoaderBrackets = {};

function BJR_BuyableLoaderBrackets.prerequisitesPresent(specializations)
    return true;
end;

function BJR_BuyableLoaderBrackets:load(xmlFile)
	self.setLoaderBrackets = SpecializationUtil.callSpecializationsFunction("setLoaderBrackets");

	self.loaderBrackets = {};
	
	self.loaderBrackets.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.loaderBrackets#index"));
	setVisibility(self.loaderBrackets.index, false);
	self.loaderBrackets.LCSIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.loaderBrackets#LCSIndex"));
	setVisibility(self.loaderBrackets.LCSIndex, false);
	
	self.loaderBrackets.attacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.loaderBrackets#attacherNode"));
	self.loaderBrackets.attacherRot = {getRotation(self.loaderBrackets.attacher)};
		
	self.loaderBrackets.cost = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.loaderBrackets#cost"), 2000);
	self.loaderBrackets.jointIndex = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.loaderBrackets#jointIndex"), 3);
	self.loaderBrackets.canSell = true;
	
	self.hasBrackets = false;
	
	self:setLoaderBrackets(self.hasBrackets, true);
end;

function BJR_BuyableLoaderBrackets:delete()
end;

function BJR_BuyableLoaderBrackets:readStream(streamId, connection)
	self:setLoaderBrackets(streamReadBool(streamId), true);
end;

function BJR_BuyableLoaderBrackets:writeStream(streamId, connection)
	streamWriteBool(streamId, self.hasBrackets); 
end;

function BJR_BuyableLoaderBrackets:readUpdateStream(streamId, timestamp, connection)
end;

function BJR_BuyableLoaderBrackets:writeUpdateStream(streamId, connection, dirtyMask)
end;

function BJR_BuyableLoaderBrackets:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BJR_BuyableLoaderBrackets:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local hasBrackets = Utils.getNoNil(getXMLBool(xmlFile, key .. "#hasBrackets"), false);
	self:setLoaderBrackets(hasBrackets);	
	
	return BaseMission.VEHICLE_LOAD_OK;
end;
 
function BJR_BuyableLoaderBrackets:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'hasBrackets="' .. tostring(self.hasBrackets) .. '" ';
	return attributes;
end;

function BJR_BuyableLoaderBrackets:keyEvent(unicode, sym, modifier, isDown)
end;

function BJR_BuyableLoaderBrackets:update(dt)
	if self.loaderBrackets.index ~= nil and self.loaderBrackets.canSell then
		if g_currentMission.player ~= nil then
			local nearestDistance1 = 2.5;	
			local nearestDistance2 = 100;			
			local x1,y1,z1 = getWorldTranslation(self.loaderBrackets.index);
			local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);		
			local distance1 = Utils.vector3Length(x1-x2,y1-y2,z1-z2);	
			local distance2 = Utils.vector3Length(g_currentMission.storeSpawnPlaces[1].startX-x2,g_currentMission.storeSpawnPlaces[1].startY-y2,g_currentMission.storeSpawnPlaces[1].startZ-z2);			
			if distance1 < nearestDistance1 and distance2 < nearestDistance2 then
				if not self.hasBrackets then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_BUY_BRACKETS"), self.loaderBrackets.cost), InputBinding.BJR_TOGGLE_BRACKETS);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_SELL_BRACKETS"), self.loaderBrackets.cost/2), InputBinding.BJR_TOGGLE_BRACKETS);
				end;
				
				if InputBinding.hasEvent(InputBinding.BJR_TOGGLE_BRACKETS) then
					self:setLoaderBrackets(not self.hasBrackets);
				end;
			elseif distance1 < nearestDistance1 then
				g_currentMission:addExtraPrintText(g_i18n:getText("BJR_BRACKETS_RANGE1"));
				g_currentMission:addExtraPrintText(g_i18n:getText("BJR_BRACKETS_RANGE2"));			
			end;
		end;
	end;
end;

function BJR_BuyableLoaderBrackets:updateTick(dt)

end;

function BJR_BuyableLoaderBrackets:draw()
end;

function BJR_BuyableLoaderBrackets:onLeave()

end;

function BJR_BuyableLoaderBrackets:onEnter()

end;

function BJR_BuyableLoaderBrackets:attachImplement(implement)
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == self.loaderBrackets.jointIndex then
		self.loaderBrackets.canSell = false;
	end;
end;

function BJR_BuyableLoaderBrackets:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == self.loaderBrackets.jointIndex then
		self.loaderBrackets.canSell = true;
	end;
end;

function BJR_BuyableLoaderBrackets:setLoaderBrackets(hasBrackets, noEventSend)
	SetLoaderBracketsEvent.sendEvent(self, hasBrackets, noEventSend);
	
	if hasBrackets then
		setRotation(self.loaderBrackets.attacher, unpack(self.loaderBrackets.attacherRot));
		if self.isServer then
			g_currentMission:addSharedMoney(-self.loaderBrackets.cost);	
		end;
	else
		setRotation(self.loaderBrackets.attacher, 0, 90, 0);
		if self.isServer then
			g_currentMission:addSharedMoney(self.loaderBrackets.cost/2);
		end;
	end;
	
	self.hasBrackets = hasBrackets;
	setVisibility(self.loaderBrackets.index, self.hasBrackets);
	setVisibility(self.loaderBrackets.LCSIndex, self.hasBrackets);
end;


-- Event class

SetLoaderBracketsEvent = {};
SetLoaderBracketsEvent_mt = Class(SetLoaderBracketsEvent, Event);

InitEventClass(SetLoaderBracketsEvent, "SetLoaderBracketsEvent");

function SetLoaderBracketsEvent:emptyNew()
    local self = Event:new(SetLoaderBracketsEvent_mt);
    self.className="SetLoaderBracketsEvent";
    return self;
end;

function SetLoaderBracketsEvent:new(vehicle, hasBrackets)
    local self = SetLoaderBracketsEvent:emptyNew()
    self.vehicle = vehicle;
	self.hasBrackets = hasBrackets;
    return self;
end;

function SetLoaderBracketsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.hasBrackets = streamReadBool(streamId);
	self.vehicle:setLoaderBrackets(self.hasBrackets, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetLoaderBracketsEvent:new(self.vehicle, self.hasBrackets), nil, connection, self.vehicle);
    end;
end;

function SetLoaderBracketsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.hasBrackets);
end;

function SetLoaderBracketsEvent.sendEvent(vehicle, hasBrackets, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLoaderBracketsEvent:new(vehicle, hasBrackets), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLoaderBracketsEvent:new(vehicle, hasBrackets));
		end;
	end;
end;
