--
-- BJR_MovingPartsInterior
-- Specialization for BJR_MovingPartsInterior 
--
-- @author  	JoXXer
-- @date  		27/03/13
--

BJR_MovingPartsInterior = {};

function BJR_MovingPartsInterior.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function BJR_MovingPartsInterior:load(xmlFile)
	self.clutchPedal = {};
	self.clutchPedal.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.clutchPedal#index"));
	self.clutchPedal.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#maxRot"), 0));
	self.clutchPedal.minRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#minRot"), 0));
	self.clutchPedal.movementSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#movementSpeed"), 0)/1000;
	
	self.breakPedalLeft = {};
	self.breakPedalLeft.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.breakPedalLeft#index"));
	self.breakPedalLeft.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.breakPedalLeft#maxRot"), 0));
	self.breakPedalLeft.minRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.breakPedalLeft#minRot"), 0));
	self.breakPedalLeft.movementSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.breakPedalLeft#movementSpeed"), 0)/1000;
	
	self.breakPedalRight = {};
	self.breakPedalRight.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.breakPedalRight#index"));
	self.breakPedalRight.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.breakPedalRight#maxRot"), 0));
	self.breakPedalRight.minRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.breakPedalRight#minRot"), 0));
	self.breakPedalRight.movementSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.breakPedalRight#movementSpeed"), 0)/1000;
	
	self.footThrottle = {};
	self.footThrottle.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.footThrottle#index"));
	
	self.RPMIndicator = {};
	self.RPMIndicator.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RPMIndicator#index"));
	self.RPMIndicator.startRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.RPMIndicator#startRot"), 0));
	
	self.fuelMeter = {};
	self.fuelMeter.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fuelMeter#index"));
	local fuelX, fuelY, fuelZ = getRotation(self.fuelMeter.index);
	self.fuelMeter.startRot = fuelY;
	self.fuelMeter.fuelPercentage = self.fuelCapacity/100;
	self.fuelMeter.hasMovedUp = false;
	
	self.tempMeter = {};
	self.tempMeter.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tempMeter#index"));
	local tempX, tempY, tempZ = getRotation(self.tempMeter.index);
	self.tempMeter.startRot = tempY;
	self.tempMeter.normalTemp = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.tempMeter#normalTemp"), 0);
	self.tempMeter.heatingUpModifier = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.tempMeter#heatingUpModifier"), 0)/1000000;
	self.tempMeter.hasMovedUp = false;
	self.tempMeter.motorTemp = 0;
	
	self.shuttleLever = {};
	self.shuttleLever.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.shuttleLever#index"));
	self.shuttleLever.forwardRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.shuttleLever#forwardRot"), 0));
	self.shuttleLever.reverseRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.shuttleLever#reverseRot"), 0));
	self.shuttleLever.neutralRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.shuttleLever#neutralRot"), 0));
	self.shuttleLever.currentDirection = 0;
end;

function BJR_MovingPartsInterior:delete()

end;

function BJR_MovingPartsInterior:readStream(streamId, connection)
end;

function BJR_MovingPartsInterior:writeStream(streamId, connection)
end;

function BJR_MovingPartsInterior:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BJR_MovingPartsInterior:keyEvent(unicode, sym, modifier, isDown)
end;

function BJR_MovingPartsInterior:update(dt)

	if self.ignitionMode == nil or self.ignitionMode == 2 then
		if self.tempMeter.motorTemp < self.tempMeter.normalTemp then
			if self.motor.lastMotorRpm  == self.motor.minRpm then 
				self.tempMeter.motorTemp = self.tempMeter.motorTemp + (self.tempMeter.heatingUpModifier * 1000);
			else
				self.tempMeter.motorTemp = self.tempMeter.motorTemp + (self.motor.lastMotorRpm * self.tempMeter.heatingUpModifier);
			end;
		end;
	else
		if self.tempMeter.motorTemp > 0 then
			self.tempMeter.motorTemp = self.tempMeter.motorTemp - (self.tempMeter.heatingUpModifier * 1000);
		end;
	end;

	if self:getIsActive() then
	
		if self.lastAcceleration ~= 0 then
			if self.footThrottle.index ~= nil then
				local footThrottleMovement = self.lastAcceleration/4;
				if footThrottleMovement < 0 then
					footThrottleMovement = -footThrottleMovement;
				end;
				setRotation(self.footThrottle.index, -footThrottleMovement, 0, 0);
			end;
		end;
		
		if self.ignitionMode == nil or self.ignitionMode >= 1 then
		
			if self.shuttleLever.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.shuttleLever.index);
				
				if self.lastAcceleration > 0 then
					if rotY > self.shuttleLever.forwardRot then
						setRotation(self.shuttleLever.index, rotX, rotY - dt * 0.005, rotZ);
					else
						setRotation(self.shuttleLever.index, rotX, self.shuttleLever.forwardRot, rotZ);
						self.shuttleLever.currentDirection = 1;
					end;
				elseif self.lastAcceleration < 0 then
					if rotY < self.shuttleLever.reverseRot then
						setRotation(self.shuttleLever.index, rotX, rotY + dt * 0.005, rotZ);
					else
						setRotation(self.shuttleLever.index, rotX, self.shuttleLever.reverseRot, rotZ);
						self.shuttleLever.currentDirection = 2;
					end;
				else
					if self.shuttleLever.currentDirection == 1 then
						if rotY < 0 then
							setRotation(self.shuttleLever.index, rotX, rotY + dt * 0.005, rotZ);
						else
							setRotation(self.shuttleLever.index, 0, 0, 0);
							self.shuttleLever.currentDirection = 0;
						end;
					elseif self.shuttleLever.currentDirection == 2 then
						if rotY > 0 then
							setRotation(self.shuttleLever.index, rotX, rotY - dt * 0.005, rotZ);
						else
							setRotation(self.shuttleLever.index, 0, 0, 0);
							self.shuttleLever.currentDirection = 0;
						end;
					else
						setRotation(self.shuttleLever.index, 0, 0, 0);
					end;
				end;
			
			end;
		
			if self.RPMIndicator.index ~= nil and (self.ignitionMode == nil or self.ignitionMode >= 2) then
				local rpmRotation = 0;
				if self.motor.lastMotorRpm == self.motor.minRpm then
					rpmRotation = math.random(self.RPMIndicator.startRot-2, self.RPMIndicator.startRot+2);
					rpmRotation = math.rad(rpmRotation);
				else
					rpmRotation = math.rad(self.motor.lastMotorRpm/13);
					rpmRotation = rpmRotation - self.RPMIndicator.startRot;
				end;
				setRotation(self.RPMIndicator.index, 0, -rpmRotation, 0);
			end;
			
			if self.fuelMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.fuelMeter.index);
				local fuelDifference = self.fuelCapacity - self.fuelFillLevel;
				local fuelMeterRot = math.rad(fuelDifference/100)*self.fuelMeter.fuelPercentage*10;
				if rotY < -fuelMeterRot and self.fuelMeter.hasMovedUp ~= true then
					setRotation(self.fuelMeter.index, 0, rotY + dt * 0.001 , 0);
				else
					self.fuelMeter.hasMovedUp = true;
					setRotation(self.fuelMeter.index, 0, -fuelMeterRot , 0);
				end;
			end;
	
			if self.tempMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.tempMeter.index);
				local tempMeterRot = math.rad(self.tempMeter.motorTemp/1.4);
				tempMeterRot = self.tempMeter.startRot - tempMeterRot;
				
				if rotY > tempMeterRot and self.tempMeter.hasMovedUp ~= true then
					setRotation(self.tempMeter.index, 0, rotY - dt * 0.001 , 0);
				else
					self.tempMeter.hasMovedUp = true;
					setRotation(self.tempMeter.index, 0, tempMeterRot , 0);
				end;
			end;
	
			if self.movingDirection == 1 and self.lastAcceleration <= 0 or self.movingDirection == -1 and self.lastAcceleration >= 0 or self.lastAcceleration == 0 then
				if self.clutchPedal.index ~= nil then
					local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
					if rotX > self.clutchPedal.maxRot then
						setRotation(self.clutchPedal.index, rotX - dt * self.clutchPedal.movementSpeed, rotY, rotZ);
					end;
				end;
			else
				if self.clutchPedal.index ~= nil then
					local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
					if rotX < self.clutchPedal.minRot then
						setRotation(self.clutchPedal.index, rotX + dt * self.clutchPedal.movementSpeed, rotY, rotZ);
					end;
				end;
			end;
			
			if self.movingDirection == 1 and self.lastAcceleration <= 0 or self.movingDirection == -1 and self.lastAcceleration >= 0 then
				if self.breakPedalLeft.index ~= nil then
					local rotX1, rotY1, rotZ1 = getRotation(self.breakPedalLeft.index);
					if rotX1 > self.breakPedalLeft.maxRot then
						setRotation(self.breakPedalLeft.index, rotX1 - dt * (self.breakPedalLeft.movementSpeed/2), rotY, rotZ);
					end;
				end;
				if self.breakPedalRight.index ~= nil then
					local rotX2, rotY2, rotZ2 = getRotation(self.breakPedalRight.index);
					if rotX2 > self.breakPedalRight.maxRot then
						setRotation(self.breakPedalRight.index, rotX2 - dt * (self.breakPedalRight.movementSpeed/2), rotY, rotZ);
					end;
				end;
			else
				if self.breakPedalLeft.index ~= nil then
					local rotX1, rotY1, rotZ1 = getRotation(self.breakPedalLeft.index);
					if rotX1 < self.breakPedalLeft.minRot then
						setRotation(self.breakPedalLeft.index, rotX1 + dt * self.breakPedalLeft.movementSpeed, rotY, rotZ);
					end;
				end;
				if self.breakPedalRight.index ~= nil then
					local rotX2, rotY2, rotZ2 = getRotation(self.breakPedalRight.index);
					if rotX2 < self.breakPedalRight.minRot then
						setRotation(self.breakPedalRight.index, rotX2 + dt * self.breakPedalRight.movementSpeed, rotY, rotZ);
					end;
				end;
			end;
		else
			if self.clutchPedal.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
				if rotX < self.clutchPedal.minRot then
					setRotation(self.clutchPedal.index, rotX + dt * self.clutchPedal.movementSpeed, rotY, rotZ);
				end;
			end;
			
			if self.breakPedalLeft.index ~= nil then
				local rotX1, rotY1, rotZ1 = getRotation(self.breakPedalLeft.index);
				if rotX1 < self.breakPedalLeft.minRot then
					setRotation(self.breakPedalLeft.index, rotX1 + dt * self.breakPedalLeft.movementSpeed, rotY, rotZ);
				end;
			end;
			
			if self.breakPedalRight.index ~= nil then
				local rotX2, rotY2, rotZ2 = getRotation(self.breakPedalRight.index);
				if rotX2 < self.breakPedalRight.minRot then
					setRotation(self.breakPedalRight.index, rotX2 + dt * self.breakPedalRight.movementSpeed, rotY, rotZ);
				end;
			end;
			
			if self.RPMIndicator.index ~= nil then
				setRotation(self.RPMIndicator.index, 0, self.RPMIndicator.startRot+math.rad(30), 0);
			end;
	
			if self.fuelMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.fuelMeter.index);
				if rotY > self.fuelMeter.startRot and self.fuelMeter.hasMovedUp == true then
					setRotation(self.fuelMeter.index, 0, rotY - dt * 0.001 , 0);
				else
					self.fuelMeter.hasMovedUp = false;
				end;
			end;
	
			if self.tempMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.tempMeter.index);
				if rotY < self.tempMeter.startRot and self.tempMeter.hasMovedUp == true then
					setRotation(self.tempMeter.index, 0, rotY + dt * 0.001 , 0);
				else
					self.tempMeter.hasMovedUp = false;
				end;
			end;
	
		end;
	end;
end;

function BJR_MovingPartsInterior:updateTick(dt)

end;

function BJR_MovingPartsInterior:draw()

end;