-- NH820TL
-- 
-- Mountable frontloader for NH T4050
--
-- Author: Sven (sven777b) Brutigam
-- Copyright (C) Halycon Media & Sven Brutigam

NH820TL = {};

function NH820TL.prerequisitesPresent(specializations)
	Vehicle.registerJointType("nhfrontloader");
    return true;
end;

function NH820TL:load(xmlFile)
    self.onTractorTrigger = NH820TL.onTractorTrigger;
    self.requestDetach = SpecializationUtil.callSpecializationsFunction("requestDetach");
    self.setAIMRindex = SpecializationUtil.callSpecializationsFunction("setAIMRindex");
    	self.konsole = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.konsole#index"));
	self.konsolentrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.konsole#trigger"));
	addTrigger(self.konsolentrigger, "onTractorTrigger", self);
	self.leitatt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leitungen#att"));
	self.leitdet = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leitungen#det"));

	self.leitungen = {};
	self.leitungen.animRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leitungen#clipNode1"));
	if self.leitungen.animRootNode ~= nil and self.leitungen.animRootNode ~= 0 then
        self.leitungen.animCharSet = getAnimCharacterSet(self.leitungen.animRootNode);
        if self.leitungen.animCharSet ~= 0 then
            local clip = getAnimClipIndex(self.leitungen.animCharSet, getXMLString(xmlFile, "vehicle.leitungen#clipSource1"));
            assignAnimTrackClip(self.leitungen.animCharSet, 0, clip);
            setAnimTrackLoopState(self.leitungen.animCharSet, 0, false);
            self.leitungen.animDuration = getAnimClipDuration(self.leitungen.animCharSet, clip);
        end;
    end;
    self.leitungen.mesh = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leitungen#mesh"));
	link(getRootNode(),self.leitungen.mesh);
	setTranslation(self.leitungen.mesh,0,0,0);
	setRotation(self.leitungen.mesh,0,0,0);
	self.backUpJointTypes = {};
	for i,j in ipairs(self.attacherJoints) do
		self.backUpJointTypes[i] = j.jointType;
	end;
	self.riegelAnimation = getXMLString(xmlFile, "vehicle.riegel#animationName");

	setVisibility(self.konsole, false);
	setVisibility(self.leitdet, true);
	setVisibility(self.leitatt, false);
	setVisibility(self.leitungen.mesh, false);
	self.lastArmRot = 0;
	self.detachRequested = false;
	self.toolAttached = false;
	self.aimr = 0;
	self.allowsLowering = false;
	self.konsoleAttached = false;

end;

function NH820TL:delete()
	removeTrigger(self.konsolentrigger);
end;

function NH820TL:readStream(streamId, connection)

end;

function NH820TL:writeStream(streamId, connection)
end;

function NH820TL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NH820TL:keyEvent(unicode, sym, modifier, isDown)
end;

function NH820TL:update(dt)
	if self:getIsActive() and self.attacherVehicle ~= nil then

		local x1,y1,z1 = getRotation(self.movingTools[1].node);
		if x1 ~= self.lastArmRot then
			local percentMove = x1 / self.movingTools[1].rotMax;
			enableAnimTrack(self.leitungen.animCharSet, 0);
			setAnimTrackTime(self.leitungen.animCharSet, 0, percentMove*self.leitungen.animDuration, true);
			disableAnimTrack(self.leitungen.animCharSet, 0);

			if self.attacherJoints[1].jointIndex > 0 or self.attacherJoints[2].jointIndex > 0 then
				local mvx = self.lastArmRot - x1;
				self.movingTools[2].curRot[1] = math.max(math.min( (self.movingTools[2].curRot[1] + mvx), self.movingTools[2].rotMax), self.movingTools[2].rotMin);
				setRotation(self.movingTools[2].node, unpack(self.movingTools[2].curRot));
				self:setMovingToolDirty(self.movingTools[2].node);
			end;
			self.lastArmRot = x1;
		end;

		if self.detachRequested then
			local allowDetach = true;
			if self.movingTools[1].curRot[1] > math.rad(5) then
				self.movingTools[1].lastRotSpeed = -0.0005;
				self:setMovingToolDirty(self.movingTools[1].node);
				allowDetach = false;
			end;
			if self.movingTools[2].curRot[1] < math.rad(5) then
				self.movingTools[2].lastRotSpeed = 0.001;
				self:setMovingToolDirty(self.movingTools[2].node);
				allowDetach = false;
			elseif self.movingTools[2].curRot[1] > math.rad(10) then
				self.movingTools[2].lastRotSpeed = -0.001;
				self:setMovingToolDirty(self.movingTools[2].node);
				allowDetach = false;
			end;
			if allowDetach then
				self.detachRequested = false;
				self.attacherVehicle:handleDetachAttachableEvent();
			end;
		end;
	end;
end;

function NH820TL:updateTick(dt)
	if self:getIsActive() and self.attacherVehicle ~= nil then

		if not self.toolAttached then
			if self.attacherVehicle == g_currentMission.controlledVehicle and g_currentMission.attachableInMountRangeVehicle == self then
				local aimr =   Utils.getNoNil(g_currentMission.attachableInMountRangeIndex,0);
				if  aimr ~= self.aimr then
					self:setAIMRindex(aimr);
				end;
			elseif g_currentMission.attachableInMountRange == nil and self.aimr > 0 then
				self:setAIMRindex(0);
			end;
			if self.aimr > 0  then
				local targetRot = -self.movingTools[1].curRot[1] + math.rad(7);
				if self.movingTools[2].curRot[1] < targetRot then
					self.movingTools[2].lastRotSpeed = 0.0006;
					self:setMovingToolDirty(self.movingTools[2].node);
				end;
			end;
		end;
	end;
end;

function NH820TL:onAttach(atv)
	setVisibility(self.leitdet, false);
	setVisibility(self.leitatt, true);
	setVisibility(self.leitungen.mesh, true);
	atv.handleDetachAttachableEvent = NH820TL.HDAE;
	removeTrigger(self.konsolentrigger);
	if not self.konsoleAttached then
		for _,a in ipairs(atv.attacherJoints) do
			if a.jointType == Vehicle.JOINTTYPE_NH4050FL then
				setVisibility(self.konsole, true);
				unlink(self.konsole);
				link(a.jointTransform, self.konsole);
				self.konsoleAttached = true;
			end;
		end;
	end;
end;

function NH820TL:onDetach()
	setVisibility(self.leitdet, true);
	setVisibility(self.leitatt, false);
	setVisibility(self.leitungen.mesh, false);
	addTrigger(self.konsolentrigger, "onTractorTrigger", self);
end;

--function NH820TL:HDAE()
--	if self.selectedImplement ~= 0 then
--		local attachable = self.attachedImplements[self.selectedImplement].object;
--		if attachable.selectedImplement == 0 or Input.isKeyPressed(Input.KEY_shift) then
--			if attachable.requestDetach then
--				attachable:requestDetach();
--			end;
--		end;
--	end;
--	return Vehicle.handleDetachAttachableEvent(self);
--end;

function NH820TL:requestDetach()
	local x1,y1,z1 = getRotation(self.movingTools[1].node);
	if x1 > math.rad(5) then
		self.allowsDetaching = false;
		self.detachRequested = true;
	else
		self.allowsDetaching = true;
		self.detachRequested = false;
	end;
end;

function NH820TL:draw()
	if self:getIsActive() then
		if g_currentMission.attachableInMountRange ~= nil and g_currentMission.attachableInMountRangeVehicle == self then
			if self.attacherJoints[g_currentMission.attachableInMountRangeIndex].jointIndex == 0 then --g_currentMission.attachableInMountRangeVehicle
				g_currentMission.hudAttachmentOverlay:render();
			end;
		end;
	end;
end;

function NH820TL:attachImplement(implement)
	local jointIndex = implement.jointDescIndex;
	local block = math.abs(jointIndex-3)
	self.attacherJoints[block].jointType = nil;
	self.toolAttached = true;
    if self.riegelAnimation ~= nil and self.playAnimation ~= nil then
        self:playAnimation(self.riegelAnimation, 1, nil, true);
    end;
end;

function NH820TL:detachImplement()
	for i,j in ipairs(self.attacherJoints) do
		j.jointType = self.backUpJointTypes[i];
	end;
	self.toolAttached = false;
    if self.riegelAnimation ~= nil and self.playAnimation ~= nil then
        self:playAnimation(self.riegelAnimation, -1, nil, true);
    end;
end;

function NH820TL:setAIMRindex(aimr, noEventSend)
	if aimr ~= self.aimr then
		NH820TLevent.sendEvent(self,aimr,noEventSend);
		self.aimr = aimr;
	end;
	if aimr > 0 then
		setVisibility(getParent(getParent(self.attacherJoints[aimr].jointTransform)),true);
		setVisibility(getParent(getParent(self.attacherJoints[math.abs(aimr-3)].jointTransform)),false);
	end;
end;

function NH820TL:onTractorTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    if (onEnter or onLeave) and self.attacherVehicle == nil then
        local vehicle = g_currentMission.nodeToVehicle[otherId];
        if vehicle ~= nil and table.getn(vehicle.attacherJoints) > 0 then
            if onEnter then
            	for _,a in ipairs(vehicle.attacherJoints) do
            		if a.jointType == Vehicle.JOINTTYPE_NH4050FL then
            			setVisibility(self.konsole, true);
            			unlink(self.konsole);
            			link(a.jointTransform, self.konsole);
            			self.konsoleAttached = true;
            		end;
            	end;
            else
            	for _,a in ipairs(vehicle.attacherJoints) do
            		if a.jointType == Vehicle.JOINTTYPE_NH4050FL then
            			setVisibility(self.konsole, false);
            			unlink(self.konsole);
            			link(self.rootNode, self.konsole);
            			self.konsoleAttached = false;
            		end;
            	end;
            end;
        end;
    end;
end;

NH820TLevent = {};
NH820TLevent_mt = Class(NH820TLevent, Event);
InitEventClass(NH820TLevent, "NH820TLevent");

function NH820TLevent:emptyNew()
    local self = Event:new(NH820TLevent_mt);
    self.className="NH820TLevent";
    return self;
end;

function NH820TLevent:new(object, index)
		local self = NH820TLevent:emptyNew()
		self.object = object;
		self.index = index;
		return self;
end;

function NH820TLevent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.index  = streamReadInt8(streamId);
    self:run(connection);
end;

function NH820TLevent:writeStream(streamId, connection)
    		streamWriteInt32(streamId, networkGetObjectId(self.object));
		streamWriteInt8(streamId, self.index);
end;

function NH820TLevent:run(connection)
	self.object:setAIMRindex(self.index, true);
	if not connection:getIsServer() then
	    g_server:broadcastEvent(NH820TLevent:new(self.object, self.index), nil, connection, self.object);
	end;	
end;

function NH820TLevent.sendEvent(vehicle, index, nes)
	if nes == nil or nes == false then
		if g_server ~= nil then
			g_server:broadcastEvent(NH820TLevent:new(vehicle, index), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(NH820TLevent:new(vehicle, index));
		end;
	end;
end;
