-- NH820Fork
-- 
-- Bale/Pallet Fork
--
-- Author: Sven (sven777b) Brutigam
-- Copyright (C) Halycon Media & Sven Brutigam

NH820Fork = {};

function NH820Fork.prerequisitesPresent(specializations)
	return true;
end;

function NH820Fork:load(xmlFile)
	self.switchTool = SpecializationUtil.callSpecializationsFunction("switchTool");
	local i=0;
	self.tools = {};
	while true do
		local bs = string.format("vehicle.tools.tool(%d)#",i);
		local index = getXMLString(xmlFile,bs.."index");
		if index == nil then break; end;
		local tool = {};
		tool.index = Utils.indexToObject(self.components, index);
		tool.name = getXMLString(xmlFile, bs.."name");
		if i>0 then
			setVisibility(tool.index,false);
		end;
		table.insert(self.tools, tool);
		i=i+1;
	end;
	self.selectedTool = 1;
end;

function NH820Fork:delete()
end;

function NH820Fork:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NH820Fork:keyEvent(unicode, sym, modifier, isDown)
end;

function NH820Fork:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.switchTool) then
			self:switchTool(self.selectedTool + 1);
		end;
	end;
end;

function NH820Fork:draw()
	if self:getIsActive() then
		local next = self.selectedTool + 1;
		if next > table.getn(self.tools) then
			next = 1;
		end;
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("nextTool"),g_i18n:getText(self.tools[next].name)), InputBinding.switchTool);
	end;
end;

function NH820Fork:switchTool(tool, noEventSend)
	if tool > table.getn(self.tools) then
		tool = 1;
	end;
	if tool ~= self.selectedTool then
		NH820ForkEvent.sendEvent(self,tool,noEventSend);
		self.selectedTool = tool;
		for i,t in ipairs(self.tools) do 
			setVisibility(t.index, i==tool);
		end;
	end;
end;


NH820ForkEvent = {};
NH820ForkEvent_mt = Class(NH820ForkEvent, Event);
InitEventClass(NH820ForkEvent, "NH820ForkEvent");

function NH820ForkEvent:emptyNew()
    local self = Event:new(NH820ForkEvent_mt);
    self.className="NH820ForkEvent";
    return self;
end;

function NH820ForkEvent:new(object, tool)
		local self = NH820ForkEvent:emptyNew()
		self.object = object;
		self.tool = tool;
		return self;
end;

function NH820ForkEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.tool  = streamReadInt8(streamId);
    self:run(connection);
end;

function NH820ForkEvent:writeStream(streamId, connection)
    		streamWriteInt32(streamId, networkGetObjectId(self.object));
		streamWriteInt8(streamId, self.tool);
end;

function NH820ForkEvent:run(connection)
	self.object:switchTool(self.tool, true);
	if not connection:getIsServer() then
	    g_server:broadcastEvent(NH820ForkEvent:new(self.object, self.tool), nil, connection, self.object);
	end;	
end;

function NH820ForkEvent.sendEvent(object, tool, nes)
	if nes == nil or nes == false then
		if g_server ~= nil then
			g_server:broadcastEvent(NH820ForkEvent:new(object, tool), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(NH820ForkEvent:new(object, tool));
		end;
	end;
end;
