-- zapfwellenJoint
-- 
-- adds support for powerShaftAttacher (compatible to community mods)
--
-- Author: Sven (sven777b) Brutigam
-- Copyright (C) Halycon Media & Sven Brutigam

zapfwellenJoint = {};

function zapfwellenJoint.prerequisitesPresent(specializations)
    return true;
end;

function zapfwellenJoint:load(xmlFile)
	local i = 0;
	local jointIndex = 1;
	while true do
		local index = getXMLString(xmlFile, string.format("vehicle.attacherJoints.attacherJoint(%d)#index", i));
		if index ~= nil then
			jointIndex = jointIndex + 1;
			i = i + 1;
		else break; end;
	end;
	i=0;
    while true do
		local base = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
		local index = getXMLString(xmlFile, base.. "#index");
		if index ~= nil then
			local zapf = getXMLString(xmlFile, base.."#zapfwelle");
			local hide = getXMLString(xmlFile, base.."#hide");
			if zapf ~= nil then
				self.attacherJoints[jointIndex].powerShaftAttacher = Utils.indexToObject(self.components, zapf);
			end;
			if hide ~= nil then
				self.attacherJoints[jointIndex].hide = Utils.indexToObject(self.components, hide);
			end;
			i = i + 1;
			jointIndex = jointIndex + 1;
		else
			break;
		end;
    end;	

end;

function zapfwellenJoint:delete()
end;

function zapfwellenJoint:mouseEvent(posX, posY, isDown, isUp, button)
end;

function zapfwellenJoint:keyEvent(unicode, sym, modifier, isDown)
end;

function zapfwellenJoint:update(dt)
end;

function zapfwellenJoint:attachImplement(implement)
	if self.attacherJoints[implement.jointDescIndex].hide ~= nil then
		setVisibility(self.attacherJoints[implement.jointDescIndex].hide, false);
	end;
end;

function zapfwellenJoint:detachImplement(implementIndex)
    local implement = self.attachedImplements[implementIndex];
	if self.attacherJoints[implement.jointDescIndex].hide ~= nil then
		setVisibility(self.attacherJoints[implement.jointDescIndex].hide, true);
	end;
end;

function zapfwellenJoint:draw()
end;
