--
-- SetTippingDirectionEvent
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--

SetTippingDirectionEvent = {};
SetTippingDirectionEvent_mt = Class(SetTippingDirectionEvent, Event);

InitEventClass(SetTippingDirectionEvent, "SetTippingDirectionEvent");

function SetTippingDirectionEvent:emptyNew()
    local self = Event:new(SetTippingDirectionEvent_mt);
    self.className="SetTippingDirectionEvent";
    return self;
end;

function SetTippingDirectionEvent:new(object, direction)
    local self = SetTippingDirectionEvent:emptyNew()
    self.object = object;
	self.direction = direction;
    return self;
end;

function SetTippingDirectionEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.direction = streamReadUIntN(streamId, 2);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetTippingDirectionEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteUIntN(streamId, self.direction, 2);
end;

function SetTippingDirectionEvent:run(connection)
    self.object:setTippingDirection(self.direction, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTippingDirectionEvent:new(self.object, self.direction), nil, connection, self.object);
    end;
end;

function SetTippingDirectionEvent.sendEvent(vehicle, direction, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTippingDirectionEvent:new(vehicle, direction), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTippingDirectionEvent:new(vehicle, direction));
		end;
	end;
end;

