--
-- SetGraintankEvent
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--

SetGraintankEvent = {};
SetGraintankEvent_mt = Class(SetGraintankEvent, Event);

InitEventClass(SetGraintankEvent, "SetGraintankEvent");

function SetGraintankEvent:emptyNew()
    local self = Event:new(SetGraintankEvent_mt);
    self.className="SetGraintankEvent";
    return self;
end;

function SetGraintankEvent:new(object, isActive)
    local self = SetGraintankEvent:emptyNew()
    self.object = object;
	self.isActive = isActive;
    return self;
end;

function SetGraintankEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isActive = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetGraintankEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isActive);
end;

function SetGraintankEvent:run(connection)
    self.object:setGraintankActive(self.isActive, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetGraintankEvent:new(self.object, self.isActive), nil, connection, self.object);
    end;
end;

function SetGraintankEvent.sendEvent(vehicle, isActive, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetGraintankEvent:new(vehicle, isActive), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetGraintankEvent:new(vehicle, isActive));
		end;
	end;
end;

