--
-- NewHollandCutterAddon
-- Specialization for NewHollandCutterAddon
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--

NewHollandCutterAddon = {};

function NewHollandCutterAddon.prerequisitesPresent(specializations)
    return true;
end;

function NewHollandCutterAddon:load(xmlFile)
	self.currentExtraObject = self.fruitExtraObjects["wheat"];
	setVisibility(self.currentExtraObject, true);
	
	self.powershaft = {};
	self.powershaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powershaft#index"));
	self.powershaft.detachRot = Utils.getRadiansFromString(getXMLString(xmlFile, "vehicle.powershaft#detachRot"), 3);
	self.powershaft.attachRot = {getRotation(self.powershaft.node)};	
	setRotation(self.powershaft.node, unpack(self.powershaft.detachRot));
	
	self.fruitObjects = {};
	self.fruitObjects.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fruitObject#index1"));
	self.fruitObjects.node1Rot = math.rad(getXMLFloat(xmlFile, "vehicle.fruitObject#index1Rot"));
	self.fruitObjects.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fruitObject#index2"));
	self.fruitObjects.node2Rot = math.rad(getXMLFloat(xmlFile, "vehicle.fruitObject#index2Rot"));
end;

function NewHollandCutterAddon:delete()
end;

function NewHollandCutterAddon:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NewHollandCutterAddon:keyEvent(unicode, sym, modifier, isDown)
end;

function NewHollandCutterAddon:update(dt)
end;

function NewHollandCutterAddon:updateTick(dt)
end;

function NewHollandCutterAddon:draw()
end;

function NewHollandCutterAddon:onAttach(attacherVehicle)
	if attacherVehicle.combineSize ~= nil then
		setRotation(self.powershaft.node, unpack(self.powershaft.attachRot));
	end;
end;

function NewHollandCutterAddon:onDetach()
	setRotation(self.powershaft.node, unpack(self.powershaft.detachRot));
end;