﻿--
-- Specialization for Cutter
--
-- @author  	Manuel Leithner
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--
-- @edit for geringhoff harveststar foldablecutter by usxi7sd 12/2013

geringhoff = {};

function geringhoff.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Foldable, specializations);
end;

function geringhoff:load(xmlFile)	
	self.geringhoff = {};
	self.geringhoff.speedScaleTime = 5000;
	self.geringhoff.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.geringhoff#speed"), 11);
	self.geringhoff.rollSpeedBackup = self.rollNodes[1].speed;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.backup = rollNode.speed;
		rollNode.speed = 0;
	end;		
	self.printFoldingError = 0;
	self.printTurnOnError = 0;
	self.printMoveError = 0;
end;

function geringhoff:delete()
end;
function geringhoff:readStream(streamId, connection)
end;
function geringhoff:writeStream(streamId, connection)
end;
function geringhoff:mouseEvent(posX, posY, isDown, isUp, button)
end;
function geringhoff:keyEvent(unicode, sym, modifier, isDown)
end;

function geringhoff:update(dt)
	Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastCutterAreaBiggerZero));
	
	if self:getIsActive() and self.reelStarted then	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.geringhoff.speed, 1.5));
	
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.geringhoff.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
	else
		if self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.geringhoff.speed, 1.5));
		
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.geringhoff.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
		end;
	end;
	
	if self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) and self.reelStarted and self.foldAnimTime < 1 then             -- will zuklappen wenn eingeschalten
			self.printFoldingError = self.time + 1800;
			self:setFoldDirection(1, false);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) and not self:isLowered(true) and self.foldAnimTime > 0.9 then   -- will zuklappen wenn gehoben
			self.printMoveError = self.time + 1800;
			self:setFoldDirection(1, false);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) and not self:isLowered(true) and self.foldAnimTime < 0.9 then   -- will aufklappen wenn gehoben
			self.printMoveError = self.time + 1800;
			self:setFoldDirection(0, false);
		end;
		if InputBinding.hasEvent(InputBinding.ACTIVATE_THRESHING) and self.foldAnimTime == 0 then                               -- will einschalten wenn zugeklappt
			self.printTurnOnError = self.time + 1800;
			self.combine:setIsThreshing(false, true);
		end; 
	end;	
end;                                                  

function geringhoff:updateTick(dt)		
end;

function geringhoff:draw()	
	if self.printFoldingError > self.time then
		g_currentMission:addWarning(g_i18n:getText("TURNOFF_CHOPPER_FIRST"), 0.018, 0.033);		
	end;
	if self.printTurnOnError > self.time then
		g_currentMission:addWarning(g_i18n:getText("UNFOLD_CHOPPER_FIRST"), 0.018, 0.033);
	end;
	if self.printMoveError > self.time then
		g_currentMission:addWarning(g_i18n:getText("MOVEDOWN_CHOPPER_FIRST"), 0.018, 0.033);
	end;
end;

function geringhoff:onAttach(attacherVehicle)
	self.combine = attacherVehicle;
end;

function geringhoff:onDetach()		
	self.combine = nil;
end; 

function geringhoff:onStartReel()
	if self.foldAnimTime < 1 then
		if self.combine.isAIThreshing then
			self.combine:stopAIThreshing(true);
			self:setFoldDirection(0, false); 
		else
			self.combine:setIsThreshing(false, true);
		end;
		self.printTurnOnError = self.time + 1800;
		self.combine.threshingStartSound = nil;
	end;
end;

--function geringhoff:setFoldDirection(direction, noEventSend)  
	--if self.reelStarted and direction == -1 then
		--self.printFoldingError = self.time + 1800;
		--self:setFoldDirection(1, false);
	--end;
--end;