

L624Cutter = {};

function L624Cutter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function L624Cutter:load(xmlFile)
	
	self.L624Cutter = {};
	
	self.L624Cutter.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.vario#speed"), 11);
	self.L624Cutter.speedScaleTime = 5000;
	self.L624Cutter.speedScaleBackup = self.reelSpeedScale;
	self.L624Cutter.rollSpeedBackup = self.rollNodes[1].speed;
	
	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;
end;

function L624Cutter:delete()
end;

function L624Cutter:readStream(streamId, connection)
end;

function L624Cutter:writeStream(streamId, connection)
end;

function L624Cutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function L624Cutter:keyEvent(unicode, sym, modifier, isDown)
end;

function L624Cutter:update(dt)
	if self:getIsActive() and self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.L624Cutter.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.L624Cutter.speedScaleBackup * percent}, {0}, 1, self.L624Cutter.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.L624Cutter.rollSpeedBackup * percent}, {0}, 1, self.L624Cutter.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		
		
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.L624Cutter.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.L624Cutter.speedScaleBackup * percent}, {0}, 1, self.L624Cutter.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.L624Cutter.rollSpeedBackup * percent}, {0}, 1, self.L624Cutter.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
	end;
end;

function L624Cutter:updateTick(dt)
	
end;

function L624Cutter:draw()	
end;

function L624Cutter:onAttach(attacherVehicle)
	
end;

function L624Cutter:onDetach()
	Cutter.updateExtraObjects(self);
end;

