
-- @author  draco13
-- @date  16/12/2010

NachlaufCutter = {};

function NachlaufCutter.prerequisitesPresent(specializations)
       return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;


function NachlaufCutter:load(xmlFile)
	local numParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rotationParts#count"), 0);
    self.rotationParts = {};
    for i=1, numParts do
        local partNamei = string.format("vehicle.rotationParts.rotationPart%d", i);
        self.rotationParts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partNamei .. "#index"));
    end;--ende--
	self.myTable = {};
end;

function NachlaufCutter:delete()
end;

function NachlaufCutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NachlaufCutter:keyEvent(unicode, sym, modifier, isDown)
end;

function NachlaufCutter:update(dt)
	if self:getIsActive() then
		if self.myTable[1] == nil then
			self.myTable[1] = 0;
		end;
		local values = Utils.getMovedLimitedValues(self.myTable, {0.005}, {0}, 1, 4500, dt, not self.reelStarted);
		self.myTable[1] = values[1];
			for k, part in pairs(self.rotationParts) do
				rotate(part, dt*self.myTable[1], 0, 0);
			end;
	end;
	if self:getIsActiveForInput() then
		if Input.isKeyPressed(Input.KEY_n) then 
			for k, part in pairs(self.rotationParts) do
				rotate(part, dt*-0.0008, 0, 0);
			end;
		end;
	end;
end;

function NachlaufCutter:draw()
	if Input.isKeyPressed(Input.KEY_n) then
		setTextColor(1, 0.0, 0.0, 1);
		renderText( 0.0, 0.0, 0.03, string.format("Ruecklauf aktiv")); 
	end;
	if self.reelStarted then
		setTextColor(0.0, 1, 0.0, 1);
		renderText( 0.0, 0.0, 0.03, string.format("   cutter aktiv")); 
	end;	
end;