
Heder = {};

function Heder.prerequisitesPresent(specializations)
    return true;
	end;

function Heder:load(xmlFile)
	self.odgarniaczlewy = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.odgarniaczlewy#index"));
	self.odgarniaczprawy = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.odgarniaczprawy#index"));
	self.stol = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stol#index"));
	self.glowne = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.glowne#index"));


    local rotationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
     if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
     if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
     end;

	self.hydraulic = {};
	self.hydraulic.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zylinder#rotIndex"));
	self.hydraulic.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zylinder#transIndex"));
	self.hydraulic.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zylinder#translationPunch"));
	self.hydraulic.rotationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zylinder#rotationPunch"));
	if self.hydraulic.punch and self.hydraulic.translationPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic.translationPunch);
		self.hydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	
	self.sidearms = {};
    self.sidearms.rot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidearms#rot"));
	self.sidearms.trans = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidearms#trans"));
    self.sidearms.movable = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.sidearms#movable"), false);
     
end;
	
	
function Heder:draw()	
end;
		
		
function Heder:update(dt)
	if  InputBinding.hasEvent(InputBinding.Heder) and self.blisko1 then
			self.lewy = not self.lewy;
	end;
	if  InputBinding.hasEvent(InputBinding.Heder) and self.blisko2 then
			self.prawy = not self.prawy;
	end;
	if  InputBinding.hasEvent(InputBinding.Stol) and self.blisko3 then
			self.rzepak = not self.rzepak;
	end;

		if self.lewy then
			self.rotationMax = true;
		else
			self.rotationMax = false;
		end;
		
		if self.prawy then
			self.rotationMax2 = true;
		else
			self.rotationMax2 = false;
		end;

		if self.rzepak then
			setVisibility(self.stol,true);
			setVisibility(self.glowne,false);
			setVisibility(self.odgarniaczlewy,false);
			setVisibility(self.odgarniaczprawy,false);
		else
			setVisibility(self.stol,false);
			setVisibility(self.glowne,true);
			setVisibility(self.odgarniaczlewy,true);
			setVisibility(self.odgarniaczprawy,true);
		end;


		if self.blisko1 then
			g_currentMission:addExtraPrintText(string.format("%s: Pozycja robocza/transportowa", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Heder)));
		end;
		if self.blisko2 then
			g_currentMission:addExtraPrintText(string.format("%s: Pozycja robocza/transportowa", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Heder)));
		end;
		if self.blisko3 then
			g_currentMission:addExtraPrintText(string.format("%s: Stol do rzepaku", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Stol)));
		end;

			local nearestDistance = 2; 
			local lx, ly, lz = getWorldTranslation(self.odgarniaczlewy); 
			local vx, vy, vz = getWorldTranslation(getCamera());
			local distance = Utils.vector3Length(lx-vx, ly-vy, lz-vz);	
			if distance < nearestDistance then
				self.blisko1 = true; 
			else
				self.blisko1 = false; 
			end;

			local nearestDistance = 2; 
			local px, py, pz = getWorldTranslation(self.odgarniaczprawy); 
			local vx, vy, vz = getWorldTranslation(getCamera());
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
			if distance < nearestDistance then
				self.blisko2 = true; 
			else
				self.blisko2 = false; 
			end;
			
			local nearestDistance = 4; 
			local sx, sy, sz = getWorldTranslation(self.stol); 
			local vx, vy, vz = getWorldTranslation(getCamera());
			local distance = Utils.vector3Length(sx-vx, sy-vy, sz-vz);	
			if distance < nearestDistance then
				self.blisko3 = true; 
			else
				self.blisko3 = false; 
			end;
		
	if self.hydraulic.node and self.hydraulic.rotationPunch and self.hydraulic.punch ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic.node);
		local bx, by, bz = getWorldTranslation(self.hydraulic.rotationPunch);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic.node, x, y, z, 0, 0, 1);
		if self.hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic.punch, 0, 0, (distance-self.hydraulic.punchDistance));
		end;
	end;

	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.isEntered then
			if self.sidearms.movable then
				local xRotHaspel, yRotHaspel, zRotHaspel = getRotation(self.sidearms.rot);
				local xTransHaspel, yTransHaspel, zTransHaspel = getTranslation(self.sidearms.trans);
				local move = 0.0065;

				if InputBinding.isPressed(InputBinding.HASPEL_UP) then
					if xRotHaspel <= Utils.degToRad(12) then
						xRotHaspel = xRotHaspel + move;
					else
						xRotHaspel = xRotHaspel;
					end;
				end;
				if InputBinding.isPressed(InputBinding.HASPEL_DOWN) then
					if xRotHaspel >= Utils.degToRad(-20) then
						xRotHaspel = xRotHaspel - move;
					else
						xRotHaspel = xRotHaspel;
					end;
				end;
				if InputBinding.isPressed(InputBinding.HASPEL_BACK) then
					if zTransHaspel <= -0.88 then
						zTransHaspel = zTransHaspel + move;
					else
						zTransHaspel = zTransHaspel;
					end;
				end;
				if InputBinding.isPressed(InputBinding.HASPEL_FORWARD) then
					if zTransHaspel >= -1.25 then
						zTransHaspel = zTransHaspel - move;
					else
						zTransHaspel = zTransHaspel;
					end;
				end;
				setRotation(self.sidearms.rot, xRotHaspel, yRotHaspel, zRotHaspel);
				setTranslation(self.sidearms.trans, xTransHaspel, yTransHaspel, zTransHaspel);
				end;
		end;
	end;

		if self.rotationPart ~= nil then
          local x, y, z = getRotation(self.rotationPart.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart.node, unpack(newRot));
        end;
        
        if self.rotationPart2 ~= nil then
          local x, y, z = getRotation(self.rotationPart2.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart2.node, unpack(newRot));
        end;
        
        if self.rotationPart3 ~= nil then
          local x, y, z = getRotation(self.rotationPart3.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart3.node, unpack(newRot));
        end;
        
		


end;

function Heder:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)  
  if not resetVehicles then
	local lewy = getXMLBool(xmlFile, key.."#lewy");
	if lewy then
	   self.lewy = true;
	end;
	local prawy = getXMLBool(xmlFile, key.."#prawy");
	if prawy then
	   self.prawy = true;
	end;
	local rzepak = getXMLBool(xmlFile, key.."#stol");
	if rzepak then
	   self.rzepak = true;
	end;
  end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Heder:getSaveAttributesAndNodes(nodeIdent)
   local attributes = 'lewy="'..tostring(self.lewy)..'" prawy="'..tostring(self.prawy)..'" stol="'..tostring(self.rzepak)..'"';
   return attributes, nil;
end;

function Heder:delete()
end;	

function Heder:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Heder:keyEvent(unicode, sym, modifier, isDown)
end;	
