--
-- ThreshingCounter
-- Specialization for counting threshed hectars
--
-- @author:  	Manuel Leithner
-- @date:		23/10/12
-- @version:	v2.0
-- @history:	v2.0 - initial implementation
--
-- free for noncommerical-usage
--

ThreshingCounter = {};

function ThreshingCounter.prerequisitesPresent(specializations)
    return true;
end;

function ThreshingCounter:load(xmlFile)
	self.sessionHectars = 0;	
	self.totalHectars = 0;
	self.tcX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ThreshingCounter#posX"), 0.5029);
	self.tcY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ThreshingCounter#posY"), 0.05238);	
	self.tcOverlay = Overlay:new("hudTCOverlay", Utils.getFilename("WH/ThreshingCounter_hud.png", self.baseDirectory), self.tcX, self.tcY, 0.2371, 0.039525);	
	
	self.sessionHectarsSent = 0;
	self.totalHectarsSent = 0;
	self.threshingCounterDirtyFlag = self:getNextDirtyFlag();
end;

function ThreshingCounter:delete()
end;

function ThreshingCounter:readStream(streamId, connection)
	local session = streamReadFloat32(streamId);
	local total = streamReadFloat32(streamId);	
	self.sessionHectars = session;
	self.totalHectars = total;
	self.sessionHectarsSent = self.sessionHectars;
	self.totalHectarsSent = self.totalHectars;
end;

function ThreshingCounter:writeStream(streamId, connection)	
	streamWriteFloat32(streamId, self.sessionHectars);
	streamWriteFloat32(streamId, self.totalHectars);
end;

function ThreshingCounter:readUpdateStream(streamId, timestamp, connection)
    if connection:getIsServer() then
        if streamReadBool(streamId) then
			self.sessionHectars = streamReadFloat32(streamId);
			self.totalHectars = streamReadFloat32(streamId);
        end;
    end;
end;

function ThreshingCounter:writeUpdateStream(streamId, connection, dirtyMask)
    if not connection:getIsServer() then
        if streamWriteBool(streamId, bitAND(dirtyMask, self.threshingCounterDirtyFlag) ~= 0) then
			streamWriteFloat32(streamId, self.sessionHectarsSent);
			streamWriteFloat32(streamId, self.totalHectarsSent);
        end;
    end;
end;

function ThreshingCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ThreshingCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function ThreshingCounter:update(dt)
end;

function ThreshingCounter:updateTick(dt)
end;

function ThreshingCounter:draw()
	
	local counterSession = math.floor(self.sessionHectars*100) / 100;
	local counterTotal = math.floor(self.totalHectars*10) / 10;
	local fullSession = math.floor(counterSession);
	local fullTotal = math.floor(counterTotal);
	local deciSession = math.floor((counterSession - fullSession)*100);
	if deciSession < 10 then
		deciSession = "0" .. deciSession;
	end;
	local deciTotal = math.floor((counterTotal - fullTotal)*10);
	
	self.tcOverlay:render();
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);	
	setTextColor(0, 0, 0, 1);
    renderText(self.tcX+0.068, 			self.tcY + 0.008, 0.022, tostring(fullTotal) .. ",");
	renderText(self.tcX+0.059+0.2371/2, self.tcY + 0.008, 0.022, tostring(fullSession) .. ",");
	setTextColor(1,1,1,1);
	renderText(self.tcX+0.068, 			self.tcY + 0.010, 0.022, tostring(fullTotal) .. ",");
	renderText(self.tcX+0.059+0.2371/2, self.tcY + 0.010, 0.022, tostring(fullSession) .. ",");
	setTextColor(0, 0, 0, 1);
    renderText(self.tcX+0.077, 			  self.tcY + 0.008, 0.023, tostring(deciTotal));
	renderText(self.tcX+0.077 + 0.2371/2, self.tcY + 0.008, 0.023, tostring(deciSession));
	setTextColor(0.95,0,0,1);
	renderText(self.tcX+0.077, 			  self.tcY + 0.010, 0.023, tostring(deciTotal));
	renderText(self.tcX+0.077 + 0.2371/2, self.tcY + 0.010, 0.023, tostring(deciSession));
	setTextColor(0, 0, 0, 1);
    renderText(self.tcX+0.097, 			self.tcY + 0.008, 0.023, "ha");
	renderText(self.tcX+0.097+0.2371/2, self.tcY + 0.008, 0.023, "ha");
	setTextColor(1,1,1,1);
	renderText(self.tcX+0.097, 			self.tcY + 0.010, 0.023, "ha");
	renderText(self.tcX+0.097+0.2371/2, self.tcY + 0.010, 0.023, "ha");
	setTextAlignment(RenderText.ALIGN_LEFT);
end;

function ThreshingCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local totalHectars = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#totalHectars"), self.totalHectars);
	self.totalHectars = totalHectars;
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ThreshingCounter:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'totalHectars="' .. tostring(self.totalHectars) ..'"';
	return attributes, nil;
end;

function ThreshingCounter:addCutterArea(cutter, area, realArea, inputFruitType, fruitType)
	if area > 0 and (self.lastCuttersFruitType == FruitUtil.FRUITTYPE_UNKNOWN or self.lastCuttersArea == 0 or self.lastCuttersFruitType == fruitType) then
		local pixelToSqm = g_currentMission:getFruitPixelsToSqm();
		local sqm = realArea*pixelToSqm;
		local ha = sqm/10000;			
		self.sessionHectars = self.sessionHectars + ha;		
		self.totalHectars = self.totalHectars + ha;	
		
		if math.abs(self.sessionHectars - self.sessionHectarsSent) > 0.01 or math.abs(self.totalHectars - self.totalHectarsSent) > 0.01 then
            self:raiseDirtyFlags(self.threshingCounterDirtyFlag);
			self.sessionHectarsSent = self.sessionHectars;
			self.totalHectarsSent = self.totalHectars;
        end;
	end;
end;