-- Claas Vario 1200 LaserPilot spec
-- by Defender
vario1200 = {};

function vario1200.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function vario1200:load(xmlFile)
  self.laserPilotStart = vario1200.laserPilotStart;
  self.laserPilotEnd = vario1200.laserPilotEnd;
  if self.isClient then
    local laserPilotRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.laserPilot#rootNode"));
    self.laserPilotCharSet = 0;
    if laserPilotRootNode ~= nil and laserPilotRootNode ~= 0 then
      self.laserPilotCharSet = getAnimCharacterSet(laserPilotRootNode);
      if self.laserPilotCharSet ~= 0 then
        local clip = getAnimClipIndex(self.laserPilotCharSet, getXMLString(xmlFile, "vehicle.laserPilot#animationClip"));
        assignAnimTrackClip(self.laserPilotCharSet, 0, clip);
        setAnimTrackLoopState(self.laserPilotCharSet, 0, false);
        self.laserPilotSpeedScale = 1;
        self.laserPilotDuration = getAnimClipDuration(self.laserPilotCharSet, clip);
        self.laserPilot = true;
      end;
    end;
  end;  
end;

function vario1200:delete()
end;

function vario1200:mouseEvent(posX, posY, isDown, isUp, button)
end;

function vario1200:keyEvent(unicode, sym, modifier, isDown)
end;

function vario1200:update(dt)
end;

function vario1200:draw()
end;

function vario1200:laserPilotStart()
  if self.laserPilot then
    if self.laserPilotCharSet ~= nil and self.laserPilotCharSet ~= 0 then
      if getAnimTrackTime(self.laserPilotCharSet, 0) < 0.0 then
        setAnimTrackTime(self.laserPilotCharSet, 0, 0.0);
      end;
      setAnimTrackSpeedScale(self.laserPilotCharSet, 0, self.laserPilotSpeedScale);
      enableAnimTrack(self.laserPilotCharSet, 0);
    end;
  end;
end;

function vario1200:laserPilotEnd()
  if self.laserPilot then
    if self.laserPilotCharSet ~= nil and self.laserPilotCharSet ~= 0 then
      if getAnimTrackTime(self.laserPilotCharSet, 0) > self.laserPilotDuration then
        setAnimTrackTime(self.laserPilotCharSet, 0, self.laserPilotDuration);
      end;
      setAnimTrackSpeedScale(self.laserPilotCharSet, 0, -self.laserPilotSpeedScale);
      enableAnimTrack(self.laserPilotCharSet, 0);
    end;
  end;
end;