--
-- Netherlands_Special_2014_v1_2
--
-- @author  Mike / www.ls-nextgeneration.com
-- @date  23/02/2014
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Netherlands_Special_2014_v1_2 = {}

local Netherlands_Special_2014_v1_2_mt = Class(Netherlands_Special_2014_v1_2, Mission00);


function Netherlands_Special_2014_v1_2:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Netherlands_Special_2014_v1_2_mt;
    end;
    local self = Netherlands_Special_2014_v1_2:superClass():new(baseDirectory, mt);
	
--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.setup_map_new ~= nil then
        --fmcSoilMod.setup_map_new(baseDirectory .. "map/fmcSoilManagement/filltypeOverlays")  -- If map provides its own fill-type HUD overlay icons.
        fmcSoilMod.setup_map_new() -- If using icons included with the SoilManagement.ZIP mod.
    end
    --## SoilMod - End ############################################################
    --#############################################################################
    return self;
end;

function Netherlands_Special_2014_v1_2:delete()
    --#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.teardown_map_delete ~= nil then
        fmcSoilMod.teardown_map_delete()
    end
    --## SoilMod - End ############################################################
    --#############################################################################
	Netherlands_Special_2014_v1_2:superClass().delete(self);
end;

function Netherlands_Special_2014_v1_2:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("Nederland.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function Netherlands_Special_2014_v1_2:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("Netherlands_Special_2014_v1_2.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 544.67785644531, 142.0139465332, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 496.71542358398, 120.50623321533, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 + 89.6, 1024 - 417.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -10.250472068787, -349.60272216797, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -10.272046089172, -282.8464050293, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 421.07974243164, -691.50701904297, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -637.43981933594, -184.55419921875, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
	-- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 522.64587402344, 424.37048339844, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 650.57104492188, 439.18130493164, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -420.5842590332, -53.419612884521, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -345.64733886719, -325.50610351563, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 378.53598022461, -314.78890991211, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -60.040184020996, 169.9811706543, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 753.5 , 1024 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 640.4 , 1024 + 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 692.7 , 1024 - 842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 786.09356689453, 604.70300292969, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 591.52893066406, -240.82275390625, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 285.96450805664, -343.73590087891, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	-- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -48.908061981201, 125.41255950928, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	-- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), -86.223808288574, 173.4656829834, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	
    Netherlands_Special_2014_v1_2:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

	--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.postInit_loadMapFinished ~= nil then
        if fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected ~= nil then
            -- If needed, set up this map's custom fruit-types fertilizer-boost and herbicide-affected attributes.
            
            -- <<Examples>>
            -- fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("tomato"   ,"fertilizer"   ,"herbicide3")
            -- fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("soybean"  ,"fertilizer2"  ,"herbicide" )
            -- fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("pumpkin"  ,"fertilizer3"  ,"herbicide2")
        end
        --
        if fmcSoilMod.setMapProperty ~= nil then
            -- Some of SoilMod's map-properties can be overwritten by the map-mod itself.
        
            -- <<Examples>>
            -- fmcSoilMod.setMapProperty("reduceWindrows",          false) -- (boolean) If windrows/swath should be reduced by 1 height-level during growth-cycle
            -- fmcSoilMod.setMapProperty("removeSprayMoisture",     true)  -- (boolean) If spray-moisture should be removed (vaporised) during growth-cycle
            fmcSoilMod.setMapProperty("disableWithering",        true)  -- (boolean) If crop withering should be disabled
            -- fmcSoilMod.setMapProperty("delayGrowthCycle#days",   2)     -- (integer) How many in-game days to skip before activating growth-cycle again
            -- fmcSoilMod.setMapProperty("startGrowthCycle#hour",   6)     -- (integer) At what hour of the in-game day should the growth-cycle start
        end
        --
        fmcSoilMod.postInit_loadMapFinished()
    end
    --## SoilMod - End ############################################################
    --#############################################################################
	
    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function Netherlands_Special_2014_v1_2:onStartMission()
    Netherlands_Special_2014_v1_2:superClass().onStartMission(self);
end;

function Netherlands_Special_2014_v1_2:mouseEvent(posX, posY, isDown, isUp, button)
    Netherlands_Special_2014_v1_2:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Netherlands_Special_2014_v1_2:keyEvent(unicode, sym, modifier, isDown)
    Netherlands_Special_2014_v1_2:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Netherlands_Special_2014_v1_2:update(dt)
    Netherlands_Special_2014_v1_2:superClass().update(self, dt);
	--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.update ~= nil then
        fmcSoilMod.update(dt)
    end
    --## SoilMod - End ############################################################
    --#############################################################################
end;

function Netherlands_Special_2014_v1_2:draw()
    Netherlands_Special_2014_v1_2:superClass().draw(self);
	--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.draw ~= nil then
        fmcSoilMod.draw()
    end
    --## SoilMod - End ############################################################
    --#############################################################################
end;