--
-- HoseRefStation
--	used for the Mannure-Mod	
--
--	author:		fruktor
--	last edit:	11.05.2013
--	version:	1.0	- initial implementaion
--
--	Copyright (C) - www.eifok-team.de
--      _  __      _           _                       
--     (_)/ _|    | |         | |                      
--  ___ _| |_ ___ | | ________| |_ ___  __ _ _ __ ___  
-- / _ \ |  _/ _ \| |/ /______| __/ _ \/ _` | '_ ` _ \ 
--|  __/ | || (_) |   <       | ||  __/ (_| | | | | | |
-- \___|_|_| \___/|_|\_\       \__\___|\__,_|_| |_| |_|
--

print("MapHoseRefStation v1.0 by fruktor --- www.eifok-team.de ");


MapHoseRefStation = {};
MapHoseRefStation.stations = {};

-- saveSelectedGame Wrapper
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	--MapHoseRefStation:saveDoorTriggerStates();
end;

function MapHoseRefStation:loadMap(name)
end;

function MapHoseRefStation:deleteMap()
end;

function MapHoseRefStation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapHoseRefStation:keyEvent(unicode, sym, modifier, isDown)
end;

function MapHoseRefStation:update(dt)

end;

function MapHoseRefStation:draw()

end;

function MapHoseRefStation:addStation(station)
	table.insert(self.stations, station)
	return table.getn(self.stations);
end;

function MapHoseRefStation:setRefState(id, state)
	if MapHoseRefStation.stations[id] ~= nil then
		MapHoseRefStation.stations[id].isUsed = state;
	end;
end;

addModEventListener(MapHoseRefStation);




--
--
--
--
--

function onCreate(self, id)
	local instance = HoseRefStation:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

HoseRefStation = {};

local HoseRefStation_mt = Class(HoseRefStation, Object);

function HoseRefStation:new(isServer, isClient)
	local self = Object:new(isServer, isClient, HoseRefStation_mt);
	self.className = "HoseRefStation";
	return self;
end;

function HoseRefStation:printTable( _tbl, _str, _dpth )
	if _dpth == 4 then
		return;
	end;
	for i,j in pairs( _tbl ) do
		print(_str.." "..tostring(i).." "..tostring(j));
		if string.match( type(j), "table" ) then
			self:printTable(j, _str.." >", _dpth+1);
		end
	end
end;

function HoseRefStation:load(id)
	--print("function HoseRefStation:load("..tostring(id));
	
	self.printTable = HoseRefStation.printTable;
	
	self.id = id;
	
	self.ref1 = getChildAt(self.id, 0);
	self.ref2 = getChildAt(self.id, 1);
	self.ref3 = getChildAt(self.id, 1);
	
	self.type = getUserAttribute(self.id, "station");
	
	self.isUsed = false;
	--self.setRefState = HoseRefStation.setRefState;
	self.setRefState = SpecializationUtil.callSpecializationsFunction("setRefState");
	
	self.manureTriggerRef = nil;
	
	if self.ref1 ~= nil and self.ref2 ~= nil then
		--print("self.ref1="..tostring(self.ref1));
		--print("self.ref2="..tostring(self.ref2));
		--print("self.ref3="..tostring(self.ref3));
		self.stationId = MapHoseRefStation:addStation(self);
	else
		print("[ERROR] MapHoseRefStation: one or two reference points are invalid, namly the first and second child of the object which has the user attribute 'MapHoseRefStation.onCreate' )");
	end;

	
end;

function HoseRefStation:loadMap(name)  
end;

function HoseRefStation:deleteMap()
end;

function HoseRefStation:delete()
end;

function HoseRefStation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HoseRefStation:keyEvent(unicode, sym, modifier, isDown)
end;

function HoseRefStation:update(dt)

end;

function HoseRefStation:updateTick(dt)
	if self.manureTriggerRef == nil then
		if string.find( self.type, "cows" ) then
			for i, trig in pairs(g_currentMission.tipTriggers) do
				if trig.animalHusbandry ~= nil then
					if trig.animalHusbandry.liquidManureTrigger ~= nil then
						if trig.animalHusbandry.liquidManureTrigger.fillLevel == 0 then
							trig.animalHusbandry.liquidManureTrigger.setFillLevel( trig.animalHusbandry.liquidManureTrigger, trig.animalHusbandry.liquidManureTrigger.fillLevel + 200000 );
						end;
						self.manureTriggerRef = trig.animalHusbandry.liquidManureTrigger;
						break;
					end
				end
			end;
		elseif string.find( self.type, "bga" ) then
			for i, trig in pairs(g_currentMission.tipTriggers) do
				if trig.bga ~= nil then
					if trig.bga.liquidManureSiloTrigger ~= nil then
						if trig.bga.liquidManureSiloTrigger.fillLevel == 0 then
							trig.bga.liquidManureSiloTrigger.setFillLevel( trig.bga.liquidManureSiloTrigger, trig.bga.liquidManureSiloTrigger.fillLevel + 500000 );
						end;
						self.manureTriggerRef = trig.bga.liquidManureSiloTrigger;
						break;
					end;
				end;
			end;
		elseif string.find( self.type, "pigs" ) then
		
			for i,j in pairs(g_currentMission.onCreateLoadedObjects) do
				if j.numSchweine ~= nil then
					if j.liquidManureSiloTrigger ~= nil then
						if j.liquidManureSiloTrigger.fillLevel == 0 then
							j.liquidManureSiloTrigger.setFillLevel( j.liquidManureSiloTrigger, j.liquidManureSiloTrigger.fillLevel + 100000 );
						end;					
						self.manureTriggerRef = j.liquidManureSiloTrigger;
						break;				
					end;
				end;			
			end;			

		end;
	end;
 
end;

function HoseRefStation:setRefState(state, noEventSend)
--print("function HoseRefStation:setRefState("..tostring(state).." "..tostring(noEventSend));
	SetStationRefStateEvent.sendEvent(self, state, noEventSend);
	self.isUsed = state;
	-- toDo? play an animation?	
end;



--
--
--
Hose_SetStationEvent = {};
Hose_SetStationEvent_mt = Class(Hose_SetStationEvent, Event);

InitEventClass(Hose_SetStationEvent, "Hose_SetStationEvent");

function Hose_SetStationEvent:emptyNew()
    local self = Event:new(Hose_SetStationEvent_mt);
    self.className="Hose_SetStationEvent";
    return self;
end;

function Hose_SetStationEvent:new(vehicle, state)
    local self = Hose_SetStationEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;

	return self;
end;

function Hose_SetStationEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function Hose_SetStationEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt32(streamId, networkGetObjectId(self.state));

end;

function Hose_SetStationEvent:run(connection)
	self.vehicle:setAttachStation(self.state, true);
	if not connection:getIsServer() then				
		g_server:broadcastEvent(Hose_SetStationEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;


function Hose_SetStationEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Hose_SetStationEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Hose_SetStationEvent:new(vehicle, state));
		end;
	end;
end;