﻿-- Trigger updater
-- @author: Sven777b
-- @date: 25.09.2010
TrafficlightOne = {};
_G.TrafficlightOne = TrafficlightOne;
function TrafficlightOne.onCreate(id)
	if _G.Trafficlights == nil then
		_G.Trafficlights = {};
	end;
	table.insert(_G.Trafficlights, TrafficlOne:new(id));
end;
function TrafficlightOne:update(dt)
	if _G.Trafficlights ~= nil then
		for k,v in pairs(_G.Trafficlights) do
			v:update(dt);
		end;
	end;
end;
function TrafficlightOne:deleteMap()
	if _G.Trafficlights ~= nil then
		for k,v in pairs(_G.Trafficlights) do
			v:delete(dt);
		end;
	end;
end;
function TrafficlightOne:delete()
end;
function TrafficlightOne:loadMap(name)
end;
function TrafficlightOne:mouseEvent(posX, posY, isDown, isUp, button)
end;
function TrafficlightOne:keyEvent(unicode, sym, modifier, isDown)
end;
function TrafficlightOne:draw()
end;

--------------------------------------------------------------------------Hauptscript----------------------------------------------------------------------------

--
-- Trafficlight system
--
-- @author Alex2009
-- @date  11/07/2012 (dd/mm/yyyy)
--
-- Hinweis: das kopieren von Sourcecode ist strafbar nach UrhG §2.1
TrafficlOne = {};
local TrafficlOne_mt = Class(TrafficlOne);

function TrafficlOne:new(id, customMt)
    local instance = {};
    if customMt ~= nil then
        setmetatable(instance, customMt);
    else
        setmetatable(instance, TrafficlOne_mt);
    end;
    instance.triggero = getChild(id, "AmpelPressTrigger01");
    instance.triggert = getChild(id, "AmpelPressTrigger02"); 
    instance.stopo = getChild(id, "AmpelCarStop01");
    local x,y,z = getTranslation(instance.stopo);
    instance.posoY = y;
    setTranslation(instance.stopo,x,(y-10),z);
    g_currentMission.nodeToVehicle[instance.stopo] = {};
    instance.stopt = getChild(id, "AmpelCarStop02");
    x,y,z = getTranslation(instance.stopt);
    instance.postY = y;
    setTranslation(instance.stopt,x,(y-10),z);
    g_currentMission.nodeToVehicle[instance.stopt] = {};           
    instance.CarRed = getChild(id, "AmpelCarRedLight");
    instance.CarOrange = getChild(id, "AmpelCarOrangeLight");
    instance.CarGreen = getChild(id, "AmpelCarGreenLight");
    instance.FeedGreen = getChild(id, "AmpelFeedGreenLight");
    instance.FeedRed = getChild(id, "AmpelFeedRedLight");
    instance.inAmpelTrigger = false;
    instance.waitForGreen = false;
    instance.Ticks = 0;
    instance.State = 0;
    addTrigger(instance.triggero, "TrafficlightCallback", instance);
    addTrigger(instance.triggert, "TrafficlightCallback", instance);
    setVisibility(instance.CarOrange,false);
    setVisibility(instance.FeedGreen,false);
    setVisibility(instance.CarGreen,true);
    setVisibility(instance.CarRed,false);
    setVisibility(instance.FeedRed,true);        
    instance.isEnabled = true;   
    return instance;
end;

function TrafficlOne:update(dt)
    if not g_currentMission.missionDynamicInfo.isMultiplayer then
        if self.inAmpelTrigger and self.isEnabled then
            if not self.waitForGreen and g_currentMission.environment.isSunOn then
                g_currentMission:addHelpButtonText(asciiToUtf8("Ampel drücken"), InputBinding.SetAmpelGreenKey);    
            elseif self.waitForGreen and self.inAmpelTrigger and (self.State < 3) then
                g_currentMission:addExtraPrintText(asciiToUtf8("Bitte warten, Signal kommt..."));
            end;
        end;
        if self.inAmpelTrigger and self.isEnabled then
            if not self.waitForGreen and g_currentMission.environment.isSunOn then
               if InputBinding.hasEvent(InputBinding.SetAmpelGreenKey) then
                    self.waitForGreen = true;
                end;
            end;
        end;
    else
        if self.inAmpelTrigger and (self.State < 3) then
            g_currentMission:addExtraPrintText("Bitte warten, Signal kommt...");
        end;
    end;
    if not g_currentMission.environment.isSunOn and self.isEnabled then
        self.Ticks = self.Ticks + dt;
        if self.Ticks > 900 then
            self.State = 0;
            self.waitForGreen = false;
            setVisibility(self.CarRed,false);
            setVisibility(self.CarOrange,not getVisibility(self.CarOrange));
            setVisibility(self.CarGreen,false);
            setVisibility(self.FeedGreen,false);
            setVisibility(self.FeedRed,false);
            self.Ticks = 0;
        end;			
    elseif not self.waitForGreen and g_currentMission.environment.isSunOn and self.isEnabled then
        if not getVisibility(self.CarGreen) then
            self.Ticks = 0;
            setVisibility(self.CarRed,false);
            setVisibility(self.CarOrange,false);
            setVisibility(self.CarGreen,true);
            setVisibility(self.FeedGreen,false);
            setVisibility(self.FeedRed,true); 
        end;		
    elseif self.waitForGreen and g_currentMission.environment.isSunOn and self.isEnabled then
        self.Ticks = self.Ticks + dt;	
        if self.Ticks > 1500 and self.State == 0 then
            self.State = 1;
            setVisibility(self.CarRed,false);
            setVisibility(self.CarOrange,true);
            setVisibility(self.CarGreen,false);
            self.Ticks = 0;
        elseif self.Ticks > 1000 and self.State == 1 then
            self.State = 2;
            local x,y,z = getTranslation(self.stopo);
            setTranslation(self.stopo,x,self.posoY,z);
            local x,y,z = getTranslation(self.stopt);
            setTranslation(self.stopt,x,self.postY,z);
            setVisibility(self.CarRed,true);
            setVisibility(self.CarOrange,false);
            setVisibility(self.CarGreen,false);
            self.Ticks = 0;
        elseif self.Ticks > 1500 and self.State == 2 then
            self.State = 3;
            setVisibility(self.FeedGreen,true);
            setVisibility(self.FeedRed,false);
            self.Ticks = 0;
        elseif self.Ticks > 6500 and self.State == 3 then
            self.State = 4;
            setVisibility(self.FeedGreen,false);
            setVisibility(self.FeedRed,true);
            self.Ticks = 0;
        elseif self.Ticks > 1500 and self.State == 4 then
            self.State = 5;
            setVisibility(self.CarRed,true);
            setVisibility(self.CarOrange,true);
            setVisibility(self.CarGreen,false);
            self.Ticks = 0;
        elseif self.Ticks > 1000 and self.State == 5 then
            self.State = 0;
            local x,y,z = getTranslation(self.stopo);
            setTranslation(self.stopo,x,y-10.0,z);
            local x,y,z = getTranslation(self.stopt);
            setTranslation(self.stopt,x,y-10.0,z);
            setVisibility(self.CarRed,false);
            setVisibility(self.CarOrange,false);
            setVisibility(self.CarGreen,true);
            self.Ticks = 0;
            self.waitForGreen = false;
        end;
    end;
end;

function TrafficlOne:delete()
    removeTrigger(self.triggero);
    removeTrigger(self.triggert);
end;

function TrafficlOne:TrafficlightCallback(triggerId, otherId, onEnter, onLeave, onStay)
    if g_currentMission.missionDynamicInfo.isMultiplayer then
        if g_currentMission.environment.isSunOn and self.isEnabled then
            if onEnter then
                self.waitForGreen = true;
                if g_currentMission.player ~= nil and g_currentMission.player.rootNode == otherId then
                    self.inAmpelTrigger = true;
                end;
            elseif onLeave then
                if g_currentMission.player ~= nil and g_currentMission.player.rootNode == otherId then
                    self.inAmpelTrigger = false;
                end;
            end;
        end;
    else
        if g_currentMission.player ~= nil and g_currentMission.player.rootNode == otherId and g_currentMission.environment.isSunOn and self.isEnabled then
            if onEnter then
                self.inAmpelTrigger = true;
            elseif onLeave then
                self.inAmpelTrigger = false;
            end;
        end;
    end;
end;
addModEventListener(TrafficlightOne);
g_onCreateUtil.addOnCreateFunction("TrafficlightOneOnCreate", TrafficlightOne.onCreate);