SetDeportEvent = {};
SetDeportEvent_mt = Class(SetDeportEvent, Event);

InitEventClass(SetDeportEvent, "SetDeportEvent");

function SetDeportEvent:emptyNew()
    local self = Event:new(SetDeportEvent_mt);
    self.className="SetDeportEvent";
    return self;
end;

function SetDeportEvent:new(vehicle, isPickupState)
    local self = SetDeportEvent:emptyNew()
    self.vehicle = vehicle;
	self.isPickupState = isPickupState;
    return self;
end;

function SetDeportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isPickupState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDeportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isPickupState);
end;

function SetDeportEvent:run(connection)   
	self.vehicle:setPickup(self.isPickupState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDeportEvent:new(self.vehicle, self.isPickupState), nil, connection, self.vehicle);
    end;
end;

function SetDeportEvent.sendEvent(vehicle, isPickupState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDeportEvent:new(vehicle, isPickupState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDeportEvent:new(vehicle, isPickupState));
		end;
	end;
end;