--
-- NaudAPN
-- Specialization for Naud APN 7 corps
--
-- @author  	Benjamin Biot (J&B Modding) et Fendt412
-- @version 	v1.0
-- @date  		21/11/10
--

NaudAPN = {};

function NaudAPN.prerequisitesPresent(specializations)
    return true;
end;

function NaudAPN:load(xmlFile)
 ----------------------
	self.setDeport= SpecializationUtil.callSpecializationsFunction("setDeport");	
-------- Animations --
	self.DeportAnimation = getXMLString(xmlFile, "vehicle.Deport#animationName");
	self.Deport = false;

	self.Axe = {};
	self.Axe[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.Axe#index1"));
	self.Axe[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.Axe#index2"));
	
	setVisibility(self.Axe[1], false);
	setVisibility(self.Axe[2], true); 

end;

function NaudAPN:delete()
end;

function NaudAPN:readStream(streamId, connection)
    self:setDeport(streamReadBool(streamId), true);
end;

function NaudAPN:writeStream(streamId, connection)
    streamWriteBool(streamId, self.Deport);
end;

function NaudAPN:readUpdateStream(streamId, timestamp, connection)
end;

function NaudAPN:writeUpdateStream(streamId, connection, dirtyMask)
end;

function NaudAPN:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NaudAPN:keyEvent(unicode, sym, modifier, isDown)
end;

function NaudAPN:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
			self:setDeport(not self.Deport);
		end;
    end;
end;

function NaudAPN:updateTick(dt)	
end;

function NaudAPN:draw()
	if self.DeportDown then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Deport_OFF"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA4);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Deport_ON"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA4);
	end;
end;

function NaudAPN:setDeport(isDeportState,noEventSend)
	SetDeportEvent.sendEvent(self, isDeportState, noEventSend);
	-- Play Deport animation --
	self.DeportDown = isDeportState;
	if self.DeportDown then
		if self.DeportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.DeportAnimation, -1, nil, true);
			self.Deport = true;
		end;
	else
		if self.DeportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.DeportAnimation, 1, nil, true);
			self.Deport = false;
		end;
	end;	
end;

function NaudAPN:onDetach()
	setVisibility(self.Axe[1], false);
	setVisibility(self.Axe[2], true);
end;

function NaudAPN:onAttach(attacherVehicle)
	setVisibility(self.Axe[1], true);
	setVisibility(self.Axe[2], false);
end;