--
-- Hydraulique
-- Specialization for Hydraulique
--
-- @author  Manuel Leithner - Fendt 412
-- @date  26/07/09
--

Hydraulique = {};

function Hydraulique.prerequisitesPresent(specializations)
    return true;
end;

function Hydraulique:load(xmlFile)

	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);
		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fenderFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		local fx, fy, fz = getWorldTranslation(self.hydraulics[i].punch);
		local ex, ey, ez = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(fx-ex, fy-ey, fz-ez);	
	end;
end;

function Hydraulique:delete()
end;

function Hydraulique:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hydraulique:keyEvent(unicode, sym, modifier, isDown)
end;

function Hydraulique:update(dt)

	for i=1, table.getn(self.hydraulics) do
		local fx, fy, fz = getWorldTranslation(self.hydraulics[i].node);
		local ex, ey, ez = getWorldTranslation(self.hydraulics[i].fenderFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), ex-fx, ey-fy, ez-fz);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		if self.hydraulics[i].punch ~= nil then
			local distance = Utils.vector3Length(fx-ex, fy-ey, fz-ez);
			setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
		end;	
	end;		
end;

function Hydraulique:draw()
end;


function Hydraulique:onAttach(attacherVehicle)
end;

function Hydraulique:onDetach()
end;


function Hydraulique:onLeave()
end;


function Hydraulique:onDeactivate()
end;

