--Waage.lua
--
--@Autor: Alex2009(www.Alex2009.de)
--
--Modifizierung erst nach rcksprache mit mir(Alex2009) erlaubt.
--Modification allowed back only after consultation with me(Alex2009).

Waage = {};
Waage_mt = Class(Waage, Object);
InitObjectClass(Waage, "Waage");

function Waage.onCreate(id)
    local object = Waage:new(g_server ~= nil, g_client ~= nil)
    if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object)
        object:register(true)
    else
        object:delete()
    end
end

function Waage:new(isServer, isClient, customMt)
    local mt = customMt
    if mt == nil then
        mt = Waage_mt
    end
    local self = Object:new(isServer, isClient, Waage_mt);
    registerObjectClassName(self, "Waage");
    return self;
end;

function Waage:load(id)    
    self.trigger = Utils.indexToObject(id,"0");
    addTrigger(self.trigger, "triggerCallback", self);
    
	self.masse = 0;
    self.WaageVehicles = {};
    self.WaageTrailer = {};
    
    local bb = Utils.indexToObject(id,"1|3");
    local cc = Utils.indexToObject(id,"1|2");
    local dd = Utils.indexToObject(id,"1|1");
    local ee = Utils.indexToObject(id,"1|0");
    self.Nummern = {};
    for ii = 0, 3, 1 do
        table.insert(self.Nummern,ii,{});
        for i = 0, 9, 1 do
            local object = bb;
            if ii == 0 then
                object = bb;
            elseif ii == 1 then
                object = cc;
            elseif ii == 2 then
                object = dd;
            else
                object = ee;
            end;
            table.insert(self.Nummern[ii],i,{Utils.indexToObject(object,tostring(i))});
            setVisibility(self.Nummern[ii][i][1],false);
        end;
    end;
    
    return true;
end;

function Waage:delete()
    unregisterObjectClassName(self);
    removeTrigger(self.trigger);
end;

function Waage:readStream(streamId, connection)
end

function Waage:writeStream(streamId, connection)
end

function Waage:deleteFinal()
end;

function Waage:update(dt)
    local masse = string.format("%.2f",self.masse);
    if self.masse > 99.99 then
        masse = "99.99";
    end;
    if self.masse < 10 then
        masse = "0"..masse;
    end;
    local numbers = {"0","0","0","0"};
    for i = 1, 4, 1 do
        local ii = i;
        if(ii > 2) then
            ii = (ii+1)
        end;
        numbers[i] = string.sub(masse,ii,ii);
        
    end;
    for i = 0, 3, 1 do
        for ii = 0, 9, 1 do
            if (tostring(ii) == numbers[(i+1)]) then
                setVisibility(self.Nummern[i][ii][1], true);
            else
                setVisibility(self.Nummern[i][ii][1], false);
            end;
        end;
    end;
end;

function Waage:updateTick()    
end;
 
function Waage:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    if onEnter then
        local vehicle = g_currentMission.nodeToVehicle[otherId];
        if vehicle ~= nil and self.WaageVehicles[vehicle] == nil then
            self.masse = self.masse + getMass(vehicle.components[1].node);
            self.WaageVehicles[vehicle] = 1;
        end;
        local trailer = g_currentMission.objectToTrailer[otherShapeId];
        if trailer ~= nil and self.WaageTrailer[trailer] == nil then
            if trailer.fillLevel ~= nil and (trailer.fillLevel/1000) ~= 0 then
                self.masse = self.masse + (trailer.fillLevel/1000);
            end;
            self.WaageTrailer[trailer] = 1;
        end;
    elseif onLeave then
        local vehicle = g_currentMission.nodeToVehicle[otherId];
        if vehicle ~= nil and self.WaageVehicles[vehicle] ~= nil then
            self.masse = math.max((self.masse - getMass(vehicle.components[1].node)),0);
            self.WaageVehicles[vehicle] = nil;
        end;
        local trailer = g_currentMission.objectToTrailer[otherShapeId];
        if trailer ~= nil and self.WaageTrailer[trailer] ~= nil then
            if trailer.fillLevel ~= nil and (trailer.fillLevel/1000) ~= 0 then
                self.masse = math.max((self.masse - (trailer.fillLevel/1000)),0);
            end;
            self.WaageTrailer[trailer] = nil;
        end;
    end;
end;
g_onCreateUtil.addOnCreateFunction("Waage", Waage.onCreate);