--
-- ClaysonCutter
-- Specialization class for Nh Clayson Cutter
--
-- @author  PeterJ - FS UK mod team
-- @date  24/11/2012
--
--

ClaysonCutter = {};
  
function ClaysonCutter.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;
  
function ClaysonCutter:load(xmlFile)
 
    self.myKnives = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myKnives#index")); 
  	self.myKnivesMaxDisplacement = 0.04;
	self.myKnivesMinDisplacement = -0.04;
	self.myKnivesDisplacement = -0.005;
	self.knivesDirection = true;

	self.cutterMode = 0;
  	self.setCutterMode = SpecializationUtil.callSpecializationsFunction("setCutterMode");
	self.cutterConfig = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cutterMode#index"));
	self.cutterConfig1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cutterMode#index1"));
	self.cutterInRange =  Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.cutterMode#rangeNode"));
	
    self.printWarningTime = 0;	
end;
  
function ClaysonCutter:delete()
end;
 

function ClaysonCutter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local cutterMode = getXMLInt(xmlFile, key.."#cutterMode");
		if cutterMode ~= nil then
			self:setCutterMode(cutterMode);
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function ClaysonCutter:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'cutterMode="'..tostring(self.cutterMode)..'"';
	return attributes, nil;
end;

function ClaysonCutter:readStream(streamId, connection)
end;
  
function ClaysonCutter:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.cutterMode);
end;

function ClaysonCutter:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function ClaysonCutter:keyEvent(unicode, sym, modifier, isDown)
end;
  
function ClaysonCutter:update(dt)
	if self:getIsActive() then
		if self.cutterMode == 0 then
			self.reelStarted = false;
		end
	end;

	if self.reelStarted then
		if self.myKnives ~= nil then
			local x,y,z = getTranslation(self.myKnives);
			local displacement = x;
			if displacement >= self.myKnivesMaxDisplacement then
				self.knivesDirection = false;
			elseif displacement <= self.myKnivesMinDisplacement then
				self.knivesDirection = true;
			end;
			if self.knivesDirection then
				displacement = x-(self.myKnivesDisplacement*2);
			else
				displacement = x+(self.myKnivesDisplacement*2);
			end;
			setTranslation(self.myKnives, displacement,y,z)
		end;
		if self:isLowered(false) then
			self.attacherVehicle.allowsThreshing = true;
		else
			self.attacherVehicle.allowsThreshing = false;
		end;
	end;

	if not self:getIsActive() then
		if self.playerInRange and not self.reelStarted then
			if self.cutterMode == 0 then
				g_currentMission:addHelpButtonText(g_i18n:getText("setDividers"), InputBinding.ACTIVATE_OBJECT);
			elseif self.cutterMode == 1 then
				g_currentMission:addHelpButtonText(g_i18n:getText("removeDividers"), InputBinding.ACTIVATE_OBJECT);			
			elseif self.cutterMode == 2 then
				g_currentMission:addHelpButtonText(g_i18n:getText("tranport"), InputBinding.ACTIVATE_OBJECT);			
			end;
			if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
				self:setCutterMode(math.abs(self.cutterMode + 1));
			end;
		end;
	else
		if self.attacherVehicle.allowsThreshing ~= nil then
			if self.cutterMode == 0 then
				if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) or InputBinding.hasEvent(InputBinding.TOGGLE_AI) then
					self:setCutterMode(math.abs(self.cutterMode));
					self.printWarningTime = self.time + 1500;
				end;
			end;
		end;
	end;
end;
  
function ClaysonCutter:updateTick(dt)
	if g_currentMission.player ~= nil then
		local nearestDistance = 2.75;
		local x1,y1,z1 = getWorldTranslation(self.cutterInRange);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.playerInRange = true;
		else
			self.playerInRange = false; 
		end;
	end;
end;
  
function ClaysonCutter:draw()
	if self.printWarningTime > self.time then
		g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
	end;
end;

function ClaysonCutter:setCutterMode(cutterMode, noEventSend)
	ClaysonCutterEvent.sendEvent(self, cutterMode, noEventSend);

	self.cutterMode = cutterMode;
	if self.cutterMode == 0 then
		setVisibility(self.cutterConfig, true);
		setVisibility(self.cutterConfig1, false);
		self.reelStarted = false;
	end;
	if self.cutterMode == 1 then
		setVisibility(self.cutterConfig, false);
		setVisibility(self.cutterConfig1, true);
	end;
	if self.cutterMode == 2 then
		setVisibility(self.cutterConfig, false);
		setVisibility(self.cutterConfig1, false);
	end;
	if self.cutterMode == 3 then
		setVisibility(self.cutterConfig, true);
		setVisibility(self.cutterConfig1, false);
	end;
	
	if self.cutterMode > 2 then
		self.cutterMode = 0;
	end;
end;


ClaysonCutterEvent = {};
ClaysonCutterEvent_mt = Class(ClaysonCutterEvent, Event);

InitEventClass(ClaysonCutterEvent, "ClaysonCutterEvent");

function ClaysonCutterEvent:emptyNew()
    local self = Event:new(ClaysonCutterEvent_mt);
    self.className="ClaysonCutterEvent";
    return self;
end;

function ClaysonCutterEvent:new(vehicle, cutterMode)
    local self = ClaysonCutterEvent:emptyNew()
    self.vehicle = vehicle;
	self.cutterMode = cutterMode;
    return self;
end;

function ClaysonCutterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.cutterMode = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ClaysonCutterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.cutterMode);	
end;

function ClaysonCutterEvent:run(connection)
	self.vehicle:setCutterMode(self.cutterMode, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ClaysonCutterEvent:new(self.vehicle, self.cutterMode), nil, connection, self.vehicle);
	end;
end;

function ClaysonCutterEvent.sendEvent(vehicle, cutterMode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ClaysonCutterEvent:new(vehicle, cutterMode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ClaysonCutterEvent:new(vehicle, cutterMode));
		end;
	end;
end;


  
