--
-- Clayson
-- This is the specialization for NH Clayson combine
--
-- @author  PeterJ - FS-UK modteam
-- @date  04/12/2012
--

Clayson = {};

function Clayson.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations) and SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function Clayson:load(xmlFile)

	local rotationPart1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationParts.rotationPart1#index"));
		if rotationPart1Node ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPart1Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart1#touchRotLimit"), 10));
    end;
	local rotationPart2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationParts.rotationPart2#index"));
    if rotationPart2Node ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPart2Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
    end;
	local rotationPart3Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationParts.rotationPart3#index"));
    if rotationPart3Node ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPart3Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart3#touchRotLimit"), 10));
    end;
	local rotationPart2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationParts.rotationPart4#index"));
		if rotationPart2Node ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPart2Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationParts.rotationPart4#touchRotLimit"), 10));
    end;
	self.pedalsMovingUp = true;

	self.rotateSpinners = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.rotateSpinners.node(%d)", i);
		local index = getXMLString(xmlFile, baseName.. "#index");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.. "#rotationSpeed"));
		local rotationSpeed = {x,y,z};
		local runOutTime = Utils.getNoNil(getXMLFloat(xmlFile, baseName.. "#runOutTime"), 2)*1000;
		if index == nil or rotationSpeed == nil or runOutTime == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			local entry = {};
			entry.node = node;
			entry.runOutTime = runOutTime;
			entry.rotationSpeedMax = rotationSpeed;
			entry.rotationSpeedMin = {0,0,0};
			entry.rotationSpeedCurrent = {0,0,0};
			table.insert(self.rotateSpinners, entry);
		end;
		i = i+1;
	end;

end;

function Clayson:delete()
end;

function Clayson:readStream(streamId, connection)
end;
  
function Clayson:writeStream(streamId, connection)
end;

function Clayson:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Clayson:keyEvent(unicode, sym, modifier, isDown)
end;

function Clayson:update(dt)
	
	if self:getIsActive() then	
	
        for cutter,implement in pairs(self.attachedCutters) do
			if cutter.cutterMode == 0 then
				self.allowsThreshing = false;
				self.isThreshing = false;
				self:stopAIThreshing();		
				self.reelStarted = false;	
                self:setIsThreshing(false);				
            end;
        end;

		inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
		if self.isEntered ~= nil then
			if self.movingDirection ~= 0 then
				if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
					self.pedalsMovingUp = true;
				else
					self.pedalsMovingUp = false;
				end;
			else
				self.pedalsMovingUp = true;
			end;
		end;
	
		local maxfuelguage = self.fuelFillLevel;
		if self.rotationPart1 ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationPart1.node);
			y = (self.rotationPart1.maxRot[2] - self.rotationPart1.minRot[2]) * (self.fuelFillLevel/self.fuelCapacity);
			setRotation(self.rotationPart1.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationPart1.node, 0, 0 ,0);
		end;
		local maxspeedguage = 22;
		local speed = self.lastSpeed*3600;
		if self.rotationPart2 ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationPart2.node);
			y = ((self.rotationPart2.maxRot[2] - self.rotationPart2.minRot[2]) / maxspeedguage) * speed + self.rotationPart2.minRot[2];
			setRotation(self.rotationPart2.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationPart2.node, 0, 0 ,0);
		end;
		if self.rotationPart3 ~= nil then
			local x, y, z = getRotation(self.rotationPart3.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.pedalsMovingUp);
			setRotation(self.rotationPart3.node, unpack(newRot));
		end;
		if self.rotationPart4 ~= nil then
			local x, y, z = getRotation(self.rotationPart4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.pedalsMovingUp);
			setRotation(self.rotationPart4.node, unpack(newRot));
		end;
	end;
end;

function Clayson:updateTick(dt)

    if self.isActive then
  		if self.isThreshing then
			for k, spinner in pairs(self.rotateSpinners) do
				local values = Utils.getMovedLimitedValues(spinner.rotationSpeedCurrent, spinner.rotationSpeedMax, spinner.rotationSpeedMin, 3, spinner.runOutTime, dt, not self.isThreshing);
				spinner.rotationSpeedCurrent = values;
				rotate(spinner.node, unpack(spinner.rotationSpeedCurrent));
			end;
		end;
	end;
end;

function Clayson:draw()
end;

function Clayson:onEnter()
end;

function Clayson:onLeave()
end;