--
-- CutterFixationEvent
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--

CutterFixationEvent = {};
CutterFixationEvent_mt = Class(CutterFixationEvent, Event);

InitEventClass(CutterFixationEvent, "CutterFixationEvent");

function CutterFixationEvent:emptyNew()
    local self = Event:new(CutterFixationEvent_mt);
    self.className="CutterFixationEvent";
    return self;
end;

function CutterFixationEvent:new(vehicle, doAttach)
    local self = CutterFixationEvent:emptyNew()
    self.vehicle = vehicle;
	self.doAttach = doAttach;
    return self;
end;

function CutterFixationEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.doAttach = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function CutterFixationEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.doAttach);
end;

function CutterFixationEvent:run(connection)
	self.vehicle:setCutterAttached(self.doAttach, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(CutterFixationEvent:new(self.vehicle, self.doAttach), nil, connection, self.vehicle);
	end;
end;

function CutterFixationEvent.sendEvent(vehicle, doAttach, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(CutterFixationEvent:new(vehicle, doAttach), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(CutterFixationEvent:new(vehicle, doAttach));
		end;
	end;
end;