--
-- ChopperSwitchEvent
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--

ChopperSwitchEvent = {};
ChopperSwitchEvent_mt = Class(ChopperSwitchEvent, Event);

InitEventClass(ChopperSwitchEvent, "ChopperSwitchEvent");

function ChopperSwitchEvent:emptyNew()
    local self = Event:new(ChopperSwitchEvent_mt);
    self.className="ChopperSwitchEvent";
    return self;
end;

function ChopperSwitchEvent:new(vehicle, isStrawActive)
    local self = ChopperSwitchEvent:emptyNew()
    self.vehicle = vehicle;
	self.isStrawActive = isStrawActive;
    return self;
end;

function ChopperSwitchEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isStrawActive = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChopperSwitchEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.isStrawActive);
end;

function ChopperSwitchEvent:run(connection)
	self.vehicle:setIsStrawActive(self.isStrawActive, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ChopperSwitchEvent:new(self.vehicle, self.isStrawActive), nil, connection, self.vehicle);
	end;
end;

function ChopperSwitchEvent.sendEvent(vehicle, isStrawActive, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChopperSwitchEvent:new(vehicle, isStrawActive), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChopperSwitchEvent:new(vehicle, isStrawActive));
		end;
	end;
end;