SetDoorPanelEvent = {};
SetDoorPanelEvent_mt = Class(SetDoorPanelEvent, Event);

InitEventClass(SetDoorPanelEvent, "SetDoorPanelEvent");

function SetDoorPanelEvent:emptyNew()
    local self = Event:new(SetDoorPanelEvent_mt);
    self.className="SetDoorPanelEvent";
    return self;
end;

function SetDoorPanelEvent:new(vehicle, isDoorState)
    local self = SetDoorPanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isDoorPanelState = isDoorState;
    return self;
end;

function SetDoorPanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDoorPanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDoorPanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isDoorPanelState);
end;

function SetDoorPanelEvent:run(connection)   
	self.vehicle:SetDoorPanel(self.isDoorPanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDoorPanelEvent:new(self.vehicle, self.isDoorPanelState), nil, connection, self.vehicle);
    end;
end;

function SetDoorPanelEvent.sendEvent(vehicle, isDoorState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDoorPanelEvent:new(vehicle, isDoorState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDoorPanelEvent:new(vehicle, isDoorState));
		end;
	end;
end;