-- SetWheelSelectionGroupEvent
-- Specialisation to send the current wheelstate
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  07/08/2011

SetWheelSelectionGroupEvent = {};
SetWheelSelectionGroupEvent_mt = Class(SetWheelSelectionGroupEvent, Event);

InitEventClass(SetWheelSelectionGroupEvent, "SetWheelSelectionGroupEvent");

function SetWheelSelectionGroupEvent:emptyNew()
    local self = Event:new(SetWheelSelectionGroupEvent_mt);
    self.className="SetWheelSelectionGroupEvent";
    return self;
end;

function SetWheelSelectionGroupEvent:new(vehicle, newSelectionGroup)
    local self = SetWheelSelectionGroupEvent:emptyNew()
    self.vehicle = vehicle;
	self.newSelectionGroup = newSelectionGroup;
    return self;
end;

function SetWheelSelectionGroupEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.newSelectionGroup = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetWheelSelectionGroupEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.newSelectionGroup);
end;

function SetWheelSelectionGroupEvent:run(connection)
	self.vehicle:setWheelSelectionGroup(self.newSelectionGroup, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetWheelSelectionGroupEvent:new(self.vehicle, self.newSelectionGroup), nil, connection, self.vehicle);
	end;
end;

function SetWheelSelectionGroupEvent.sendEvent(vehicle, newSelectionGroup, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetWheelSelectionGroupEvent:new(vehicle, newSelectionGroup), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetWheelSelectionGroupEvent:new(vehicle, newSelectionGroup));
		end;
	end;
end;