--
-- NHBB980
-- Specialization for New Holland BB 980 from Strawmod
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		21/11/10
--

NHBB980 = {};

function NHBB980.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function NHBB980:load(xmlFile)
	self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, NHBB980.getIsAreaActive);	
	self.setTransport= SpecializationUtil.callSpecializationsFunction("setTransport");	
	self.setPickup= SpecializationUtil.callSpecializationsFunction("setPickup");	
	-- Animations --
	self.PickupAnimation = getXMLString(xmlFile, "vehicle.Pickup#animationName");
	self.TransportAnimation = getXMLString(xmlFile, "vehicle.Transport#animationName");
	self.Transport = true;
	self.Pickup = false;
	-- Animated objects --
	self.numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);	
    self.RotParts = {};
    for i=1, self.numRotParts do
        local RotPartsnamei = string.format("vehicle.RotParts.RotPart" .. "%d", i);
        self.RotParts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, RotPartsnamei .. "#index"));
    end;
	self.PickupWheels = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PickupWheels#index"));
	-- Particles --
	self.PickUpParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.PickUpParticleSystems.PickUpParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.PickUpParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
end;

function NHBB980:delete()
	Utils.deleteParticleSystem(self.PickUpParticleSystems);
end;

function NHBB980:readStream(streamId, connection)
    self:setPickup(streamReadBool(streamId), true);
    self:setTransport(streamReadBool(streamId), true);
end;

function NHBB980:writeStream(streamId, connection)
    streamWriteBool(streamId, self.Pickup);
    streamWriteBool(streamId, self.Transport);
end;

function NHBB980:readUpdateStream(streamId, timestamp, connection)
end;

function NHBB980:writeUpdateStream(streamId, connection, dirtyMask)
end;

function NHBB980:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NHBB980:keyEvent(unicode, sym, modifier, isDown)
end;

function NHBB980:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self:setPickup(not self.Pickup);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:setTransport(not self.Transport);
		end;
    end;
end;

function NHBB980:updateTick(dt)	
	if self:getIsActive() then	
		-- Animating the pickup elements --
		if self.isTurnedOn and not self.Transport then
			for i=1, 2 do
				rotate(self.RotParts[i], -0.01 * dt, 0, 0);
			end;
			for i=3, 5 do
				rotate(self.RotParts[i], 0, 0, -0.01 * dt);
			end;
			rotate(self.PickupWheels, 2.5 * self.lastSpeedReal * self.movingDirection * dt ,0,0);
		end;			
		-- Activate particles --
		if self.isTurnedOn and not self.Transport and self.movingDirection ~= 0 and self.PickupDown then
			Utils.setEmittingState(self.PickUpParticleSystems, true);
		else
			Utils.setEmittingState(self.PickUpParticleSystems, false);
		end;
	end;	
end;

function NHBB980:draw()
	if self.Transport then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORT_OFF"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
    else
		if self.PickupDown then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_LIFT"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORT_ON"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_LOWER"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
		end;
    end;	
end;

function NHBB980:setTransport(isTransport,noEventSend)
	SetTransportEvent.sendEvent(self, isTransport, noEventSend);
	-- Play transport animation --
	if isTransport then
		if self.TransportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransportAnimation, -1, nil, true);
			self.Transport = true;
		end;
	else
		if self.TransportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransportAnimation, 1, nil, true);
			self.Transport = false;
		end;
	end;
end;

function NHBB980:setPickup(isPickupState,noEventSend)
	SetPickupEvent.sendEvent(self, isPickupState, noEventSend);
	-- Play pickup animation --
	self.PickupDown = isPickupState;
	if self.PickupDown then
		if self.PickupAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PickupAnimation, -1, nil, true);
			self.Pickup = true;
		end;
	else
		if self.PickupAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PickupAnimation, 1, nil, true);
			self.Pickup = false;
		end;
	end;	
end;

function NHBB980:onDetach()
	if self.PickUpParticleSystems ~= nil then
		Utils.setEmittingState(self.PickUpParticleSystems, false);
	end;
end;

function NHBB980:getIsAreaActive(superFunc, area)
    if superFunc ~= nil then
			return superFunc(self, area) and self.PickupDown;
    end;
	return self.PickupDown;	
end;