UnloadBB9090Event = {};
UnloadBB9090Event_mt = Class(UnloadBB9090Event, Event);

InitEventClass(UnloadBB9090Event, "UnloadBB9090Event");

function UnloadBB9090Event:emptyNew()
    local self = Event:new(UnloadBB9090Event_mt);
    self.className="UnloadBB9090Event";
    return self;
end;

function UnloadBB9090Event:new(vehicle, mode)
    local self = UnloadBB9090Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function UnloadBB9090Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function UnloadBB9090Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function UnloadBB9090Event:run(connection)
	self.vehicle:UnloadBB9090(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(UnloadBB9090Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function UnloadBB9090Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(UnloadBB9090Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(UnloadBB9090Event:new(vehicle, mode));
		end;
	end;
end;