﻿--
-- Ford 8340
--
-- author  Mythos
-- date  23/01/2012
-- www.ARM-Team.gr
-- Copyright (C) ARM Team, All Rights Reserved.

Ford8340 = {};
--________________________________________________________________________________________________________________________________________________________
function Ford8340.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:load(xmlFile)

	-- Functions
	self.OPER= SpecializationUtil.callSpecializationsFunction("OPER");
	
	-- Animations
	self.rdAnim = getXMLString(xmlFile, "vehicle.rdAnim#animationName");
	self.ldAnim = getXMLString(xmlFile, "vehicle.ldAnim#animationName");
	self.bwAnim = getXMLString(xmlFile, "vehicle.bwAnim#animationName");


	--Indexs
	self.fwLights = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.lightsaddon.light(0)#index"));
	self.rwLights = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.lightsaddon.light(1)#index"));
	self.backAtt = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.backAttacher#index"));
	self.baTransMin = getXMLFloat(xmlFile,"vehicle.backAttacher#transMin");
	self.baTransMax = getXMLFloat(xmlFile,"vehicle.backAttacher#transMax");
	
	self.bSwitch = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.bSwitch#index"));
	self.bSwitchC = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.bSwitchC#index"));
	
	self.aSwitch = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.aSwitch#index"));
	self.aSwitchC = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.aSwitchC#index"));
	
	self.lSwitch = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.lSwitch#index"));
	self.lSwitchC = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.lSwitchC#index"));
	
	self.wfSwitch = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.wfSwitch#index"));
	self.wfSwitchC = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.wfSwitchC#index"));
	self.wfLight = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.lightsaddon.light(0)#index"));
	
	self.wrSwitch = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.wrSwitch#index"));
	self.wrSwitchC = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.wrSwitchC#index"));
	self.wrLight = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.lightsaddon.light(1)#index"));
	
	self.rfender = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.rFender#index"));
	self.lfender = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.lFender#index"));
	
	self.RR2 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.RR2#index"));
	self.RL2 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.RL2#index"));
	
	-- Booleans
	self.rd = false;
	self.ld = false;
	self.bw = false;
	self.fenders = true;
	self.dw = false;
	self.fg = false;

	
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:delete()

end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:mouseEvent(posX, posY, isDown, isUp, button)

end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:keyEvent(unicode, sym, modifier, isDown)

end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:update(dt)

	if self:getIsActiveForInput() and self:getIsActive() then
		
		if InputBinding.hasEvent(InputBinding.F8340_RD) then
			self:OPER(1, not self.rd);
		end;
		
		if InputBinding.hasEvent(InputBinding.F8340_LD) then
			self:OPER(2, not self.ld);
		end;
		
		if InputBinding.hasEvent(InputBinding.F8340_BW) then
			self:OPER(3, not self.bw);
		end;
		
		if InputBinding.hasEvent(InputBinding.NH_DWHEELS) then
			self:OPER(4, not self.dw);
		end;
		
		if InputBinding.hasEvent(InputBinding.NH_FENDERS) then
			self:OPER(5, not self.fenders);
		end;
		
		if InputBinding.isPressed(InputBinding.BACK_ATTACHER_UP) then
			self:OPER(7);
		end;
		
		if InputBinding.isPressed(InputBinding.BACK_ATTACHER_DOWN) then
			self:OPER(8);
		end;
		
		-- Switches
		if self.beaconLightsActive then
			setRotation(self.bSwitch, 0, 0, math.rad(15));
			setVisibility(self.bSwitchC, true);
		else
			setRotation(self.bSwitch, 0, 0, 0);
			setVisibility(self.bSwitchC, false);
		end;
		
		if self.B3.wl then
			setRotation(self.aSwitch, math.rad(15), 0, 0);
			setVisibility(self.aSwitchC, true);
		else
			setRotation(self.aSwitch, 0, 0, 0);
			setVisibility(self.aSwitchC, false);
		end;
		
		if self.realLightsActive then
			setRotation(self.lSwitch, math.rad(15), 0, 0);
			setVisibility(self.lSwitchC, true);
		else
			setRotation(self.lSwitch, 0, 0, 0);
			setVisibility(self.lSwitchC, false);
		end;
		
		if getVisibility(self.wfLight) then
			setRotation(self.wfSwitch, math.rad(15), 0, 0);
			setVisibility(self.wfSwitchC, true);
		else
			setRotation(self.wfSwitch, 0, 0, 0);
			setVisibility(self.wfSwitchC, false);
		end;
		
		if getVisibility(self.wrLight) then
			setRotation(self.wrSwitch, math.rad(15), 0, 0);
			setVisibility(self.wrSwitchC, true);
		else
			setRotation(self.wrSwitch, 0, 0, 0);
			setVisibility(self.wrSwitchC, false);
		end;

	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:updateTick(dt)
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:draw()
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:OPER(mode, state, noEventSend)
	Ford8340Event.sendEvent(self, mode, state, noEventSend);
	
	if mode==1 then
		if state then
			self:playAnimation(self.rdAnim, 1, nil, true);
			self.rd = true;
		else
			self:playAnimation(self.rdAnim, -1, nil, true);
			self.rd = false;
		end;
	elseif mode==2 then
		if state then
			self:playAnimation(self.ldAnim, 1, nil, true);
			self.ld = true;
		else
			self:playAnimation(self.ldAnim, -1, nil, true);
			self.ld = false;
		end;
	elseif mode==3 then
		if state then
			self:playAnimation(self.bwAnim, 1, nil, true);
			self.bw = true;
		else
			self:playAnimation(self.bwAnim, -1, nil, true);
			self.bw = false;
		end;
	elseif mode==4 then
		if state then
			setVisibility(self.RR2, true);
			setVisibility(self.RL2, true);
			self.dw = true;
		else
			setVisibility(self.RR2, false);
			setVisibility(self.RL2, false);
			self.dw = false;
		end;
	elseif mode==5 then
		if state then
			setVisibility(self.rfender, true);
			setVisibility(self.lfender, true);
			self.fenders = true;
		else
			setVisibility(self.rfender, false);
			setVisibility(self.lfender, false);
			self.fenders = false;
		end;
	elseif mode==7 then
		local x,y,z = getTranslation(self.backAtt);
		if y<self.baTransMax then
			translate(self.backAtt, 0,0.001,0);
		end;
	elseif mode==8 then
		local x,y,z = getTranslation(self.backAtt);
		if y>self.baTransMin then
			translate(self.backAtt, 0,-0.001,0);
		end;
	end;

end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:readStream(streamId, connection)
	self.rd = streamReadBool(streamId);
	self.ld = streamReadBool(streamId);
	self.bw = streamReadBool(streamId);
	self.fg = streamReadBool(streamId);
	self.fenders = streamReadBool(streamId);
	self.dw = streamReadBool(streamId);
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:writeStream(streamId, connection)
    streamWriteBool(streamId, self.rd);
    streamWriteBool(streamId, self.ld);
	streamWriteBool(streamId, self.bw);
	streamWriteBool(streamId, self.fg);
	streamWriteBool(streamId, self.fenders);
	streamWriteBool(streamId, self.dw);
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.rd = Utils.getNoNil(getXMLBool(xmlFile, key.."#rd"),false);
		self.ld = Utils.getNoNil(getXMLBool(xmlFile, key.."#ld"),false);
		self.bw = Utils.getNoNil(getXMLBool(xmlFile, key.."#bw"),false);
		self.fg = Utils.getNoNil(getXMLBool(xmlFile, key.."#fg"),true);
		self.dw = Utils.getNoNil(getXMLBool(xmlFile, key.."#dw"),false);
		self.fenders = Utils.getNoNil(getXMLBool(xmlFile, key.."#fenders"),true);
		
		if self.rd then
			self:playAnimation(self.rdAnim, 100, nil, true);
		end;
		if self.ld then
			self:playAnimation(self.ldAnim, 100, nil, true);
		end;
		if self.bw then
			self:playAnimation(self.bwAnim, 100, nil, true);
		end;
		self:OPER(4, self.dw);
		self:OPER(5, self.fenders);
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function Ford8340:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'rd="'..tostring(self.rd)..
	'" ld="'..tostring(self.ld)..
	'" bw="'..tostring(self.bw)..
	'" dw="'..tostring(self.dw)..
	'" fenders="'..tostring(self.fenders)..
	'" fg="'..tostring(self.fg)..'"';
	local nodes = nil;
	
	return attributes,nodes;
end;
