--
-- MxCoupling
-- Specialization for the Mx weights
--
-- author		: DerLord (Dennis)
-- @date		: 16.06.13
-- @version		: v1.0
--
-- Copyright all rights Reserved (c)
--

mx = {};

function mx.prerequisitesPresent(specializations)
	Vehicle.registerJointType("MxCoupling");
    return true;
end;

function mx:load(xmlFile)
end;

function mx:delete()
end;

function mx:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mx:keyEvent(unicode, sym, modifier, isDown)
end;

function mx:update(dt)
end;

function mx:updateTick(dt)
end;

function mx:draw()	
end;

function mx:onAttacher(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
	for k,v in pairs(self.attachedImplements) do
		if v.object.onMxCouplerAttach ~= nil then
            v.object:onMxCouplerAttach(attacherVehicle);
		end;
    end;
end;

function mx:onDetach()
	self.attacherVehicleCopy = nil;
	for k,v in pairs(self.attachedImplements) do
		if v.object.onMxCouplerDetach ~= nil then
            v.object:onMxCouplerDetach(attacherVehicle);
		end;
    end;
end;