--
-- secondTippingPS  v0.9 
-- Specialization to add a 2nd particle system with fillLevel contraints to tipping animations

-- by upsidedown
-- 
-- frei verwendbar - keine erlaubnis ntig  |  free for use - no permission needed.
-- Modifikationen erst nach Rcksprache!    |  modifications only with my permission.

secondTippingPS = {};

function secondTippingPS.prerequisitesPresent(specializations)
    return true; --check for Trailer
end;

function secondTippingPS:load(xmlFile)

	if self.isClient then
		for j,tipAnimation in pairs(self.tipAnimations) do
			local key = string.format("vehicle.tipAnimations.tipAnimation(%d)", j-1);

            tipAnimation.secondDischargeParticleSystems = {};
            local i = 0;
            while true do
                local keyPS = string.format(key..".secondDischargeParticleSystems.dischargeParticleSystem(%d)", i);
                local t = getXMLString(xmlFile, keyPS .. "#type");
				
                if t == nil then
                    break;
                end;
				
                local fillType = Fillable.fillTypeNameToInt[t];
				local startValue = getXMLFloat(xmlFile, keyPS .. "#start");
				local endValue = getXMLFloat(xmlFile, keyPS .. "#end");
                if fillType ~= nil then
                    local currentPS = {};
                    local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, keyPS, self.components, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
					currentPS.startValue = startValue;
					currentPS.endValue = endValue;
                    tipAnimation.secondDischargeParticleSystems[fillType] = currentPS;
					print("2nd PS: loaded for tipAnimation: "..j.."  fillType: "..t)
                end;

                i = i + 1;
            end;
        end
	end;	
end;

function secondTippingPS:postLoad(xmlFile)
	
end;

function secondTippingPS:readStream(streamId, timestamp, connection)
	
end;

function secondTippingPS:writeStream(streamId, connection, dirtyMask)
	
end;

function secondTippingPS:update(dt)
		
end;

function secondTippingPS:updateTick(dt)
	if self:getIsActive() then		
        if self.isClient then
            if self.currentTipReferencePointIndex ~= nil then
                local tipAnimation = self.tipAnimations[self.currentTipReferencePointIndex];
                if tipAnimation ~= nil then
					local PS = tipAnimation.secondDischargeParticleSystems[self.currentFillType];
                    if (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) and self.fillLevel > PS.endValue and self.fillLevel <= PS.startValue and self:getCurrentTipAnimationTime() >= tipAnimation.dischargeStartTime then
                        Utils.setEmittingState(PS, true);
						--print("turning on")
                    else
                        Utils.setEmittingState(PS, false);
						--print("turning off")
                    end;
                end
            end  
           
        end;
	end;
end;

function secondTippingPS:draw()
	
end;

function secondTippingPS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function secondTippingPS:keyEvent(unicode, sym, modifier, isDown)
end;

function secondTippingPS:delete()
	if self.isClient then
		for _, tipAnimations in pairs(self.tipAnimations) do
			for _, particleSystem in pairs(tipAnimations.secondDischargeParticleSystems) do
				Utils.deleteParticleSystem(particleSystem);
			end
		end
	end
end;