--[[************************************************************************************************************************************************************
	
	mrWheelsSwitch v 1.1.1 ... Events for MP and DS
	
	07/2014 © Saty MODS (Saty / http://forum.lsczech.cz)
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
	This work is licensed under a Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License (Attribution / NonCommercial / NoDerivatives)
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.en
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
	Toto dilo podleha licenci : Creative Commons 4.0 International - Uvedte autora / Neuzivejte dilo komercne / Nezasahujte do dila 
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.cs
	
************************************************************************************************************************************************************]]--


mrWheelsSwitchToggleModeEvent = {};
mrWheelsSwitchToggleModeEvent_mt = Class(mrWheelsSwitchToggleModeEvent, Event);

InitEventClass(mrWheelsSwitchToggleModeEvent, "mrWheelsSwitchToggleModeEvent");
 
function mrWheelsSwitchToggleModeEvent:emptyNew()
	local self = Event:new(mrWheelsSwitchToggleModeEvent_mt);
	self.className = "mrWheelsSwitchToggleModeEvent";
	return self;
end;

function mrWheelsSwitchToggleModeEvent:new(object, wheelsSwitchMode)
	local self = mrWheelsSwitchToggleModeEvent:emptyNew();
	self.wheelsSwitchMode = wheelsSwitchMode;
	self.object = object;
	return self;
end;

function mrWheelsSwitchToggleModeEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	if connection:getIsServer() then
		self.wheelsSwitchMode = streamReadInt8(streamId);
	end;
	self.object = networkGetObject(id);
	if self.object ~= nil then
		self:run(connection);
	end;
end;

function mrWheelsSwitchToggleModeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	if not connection:getIsServer() then
		streamWriteInt8(streamId, self.wheelsSwitchMode);
	end;
end;

function mrWheelsSwitchToggleModeEvent:run(connection)
	if not connection:getIsServer() then
		self.object:wheelsSwitchSetNextMode();
	else
		self.object:wheelsSwitchChangeMode(self.wheelsSwitchMode);
	end;
end;