--[[************************************************************************************************************************************************************
	
	mrWheelsSwitch v1.1.1
	
	07/2014 © Saty MODS (Saty / http://forum.lsczech.cz)
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
	This work is licensed under a Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License (Attribution / NonCommercial / NoDerivatives)
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.en
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
	Toto dilo podleha licenci : Creative Commons 4.0 International - Uvedte autora / Neuzivejte dilo komercne / Nezasahujte do dila 
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.cs
	
	--------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	Zapis do XML souboru stroje :
	*****************************
	
	<wheelsSwitch defaultWheels="1" onlyInRepairTrigger="false">
		<wheelsMode name="WHEELS_1" /> 
		<wheelsMode mass="0.6" comTrans="0 0 -1.36" realVehicleFlotationFx="1.25" realRollingResistance="0.2" name="WHEELS_2">
			<wheel index="4>1|2" /> 
			<wheel index="5>1|2" /> 
		</wheelsMode>
	</wheelsSwitch>
	
	
	Vysvetlivky k funkcim:
	
	defaultWheels				- defaultni kola pri koupi stroje
	onlyInRepairTrigger			- kola jdou menit pouze v RepairTriggeru (DamageMod nebo placeable trigger) [nemusi se zadavat, pri nezadani defaultni hodnota "false"]
	wheelsMode					- jednotlive mody kol  
	mass						- vaha, ktera se prida k vaze stroje [nemusi se zadavat, pri nezadani defaultni hodnota "0"]
	comTrans					- souradnice (X Y Z), na ktere se prida zadana vaha [nemusi se zadavat, pri nezadani defaultni hodnota "0 0 0"]
	realVehicleFlotationFx		- 1 = standardni kola, 0.75 = uzka kola, 1.25 = zdvojena kola, 1.4 = pasy [nemusi se zadavat, pri nezadani defaultni hodnota prebrana z MR]
	realRollingResistance		- valivy odpor kol [nemusi se zadavat, pri nezadani defaultni hodnota prebrana z MR]
	wheel						- jednotliva kola
	index						- index pro dane kolo, ktere se zvidelnuje/zneviditelnuje
	name						- nazev skupiny kol (musi byt shodny s nazvy v <l10n>
	
	--------------------------------------------------------------------------------------------------------------------------------------------------------
	
	Zapis do souboru modDesc.xml :
	******************************
	
	vsadit do <specializations> :
		<specialization name="mrWheelsSwitch"  className="mrWheelsSwitch"  filename="scripts/mrWheelsSwitch.lua"/>
	
	vsadit do <vehicleTypes> :
		<specialization name="mrWheelsSwitch" />
		
	vsadit do <l10n> :
		<text name="WHEELS_SWITCH"><en>Wheels switch</en><cz>Změna kol</cz></text>
		<text name="WHEELS_1"><en>Normal wheels</en><cz>Normální kola</cz></text>
		<text name="WHEELS_2"><en>Back dual wheels</en><cz>Zdvojená zadní kola</cz></text>
		<text name="WHEELS_3"> ...
		( WHEELS_# neni nutno zadavat, skript je osetren tak, aby pri nezadani hodnoty ukazoval defaultni hodnotu "WHEELS_SWITCH". )
	
	vsadit do <inputBindings> :
		<input name="WHEELS_SWITCH" key1="KEY_KP_0" />
	
************************************************************************************************************************************************************]]--

source(g_currentModDirectory .. "scripts/mrWheelsSwitchEvent.lua");  -- pokud nejsou skripty umistene ve slozce "scripts" tak zde upravit cestu !!
mrWheelsSwitch = {};

function mrWheelsSwitch.prerequisitesPresent(specializations)
	return true;
end;

function mrWheelsSwitch:load(xmlFile)
	self.wheelsSwitchSetNextMode = SpecializationUtil.callSpecializationsFunction("wheelsSwitchSetNextMode");
	self.wheelsSwitchChangeMode = SpecializationUtil.callSpecializationsFunction("wheelsSwitchChangeMode");

	self.wheelsSwitchMode = {};
	local i = 0;
	while true do
		local modePath = string.format("vehicle.wheelsSwitch.wheelsMode(%d)", i);
		if not hasXMLProperty(xmlFile, modePath) then
			break;
		end;
		
		self.wheelsSwitchMode[i+1] = {};
		self.wheelsSwitchMode[i+1].wheels = {};
		local j = 0;
		while true do
			local wheelsPath = string.format("vehicle.wheelsSwitch.wheelsMode(%d).wheel(%d)", i, j);
			if not hasXMLProperty(xmlFile, wheelsPath) then
				break;
			end;
			
			local index = getXMLString(xmlFile, wheelsPath.. "#index");
			local object = Utils.indexToObject(self.components, index);
			if object == nil then
				print("**************  WARNING : mrWheelsSwitch: load => wheel object is nil ! index in xml = " .. tostring(index));
			end;
			
			self.wheelsSwitchMode[i+1].wheels[j+1] = object;
			j = j + 1;
		end;
		
		self.wheelsSwitchMode[i+1].mass = Utils.getNoNil(getXMLFloat(xmlFile, modePath .. "#mass"), 0);
		local x, y, z = 0, 0, 0;
		local comTrans = getXMLString(xmlFile, modePath .. "#comTrans");
		if comTrans ~= nil then
			Utils.getVectorFromString(comTrans);
		end;
		self.wheelsSwitchMode[i+1].comTrans = {x=x, y=y, z=z};
		self.wheelsSwitchMode[i+1].realVehicleFlotationFx = Utils.getNoNil(getXMLFloat(xmlFile, modePath .. "#realVehicleFlotationFx"), self.realVehicleFlotationFx);
		self.wheelsSwitchMode[i+1].realRollingResistance = Utils.getNoNil(getXMLFloat(xmlFile, modePath .. "#realRollingResistance"), self.realRollingResistance);
		self.wheelsSwitchMode[i+1].name = Utils.getNoNil(getXMLString(xmlFile, modePath .. "#name"), "WHEELS_SWITCH");
		i = i + 1;
	end;
	
	self.wheelsSwitchMode.maxMode = i;
	local currentMode = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wheelsSwitch#defaultWheels"), 1);
	self.wheelsSwitchMode.onlyRepair = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheelsSwitch#onlyInRepairTrigger"), false);
	
	self:wheelsSwitchChangeMode(currentMode);
	RealisticVehicle.registerExtraMassGetter(self, mrWheelsSwitch.getCurrentMass);
end;

function mrWheelsSwitch:readStream(streamId, connection)
	self:wheelsSwitchChangeMode(streamReadInt8(streamId));
end;
 
function mrWheelsSwitch:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.wheelsSwitchMode.currentMode);
end;

function mrWheelsSwitch:update(dt)
	if not self.wheelsSwitchMode.onlyRepair or (self.wheelsSwitchMode.onlyRepair and self.isInRepairTrigger) then
		if self:getIsActiveForInput(true) and InputBinding.hasEvent(InputBinding.WHEELS_SWITCH) then
			self:wheelsSwitchSetNextMode();
		end;
	end;
end;

function mrWheelsSwitch:draw()
	if not self.wheelsSwitchMode.onlyRepair or (self.wheelsSwitchMode.onlyRepair and self.isInRepairTrigger) then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.wheelsSwitchMode[self.wheelsSwitchMode.currentMode].name) .. " (" .. self.wheelsSwitchMode.currentMode .. "/" .. self.wheelsSwitchMode.maxMode .. ")"), InputBinding.WHEELS_SWITCH);
	end;
end;

function mrWheelsSwitch:wheelsSwitchSetNextMode(noEventSend)
	if self.isServer then
		local nextMode = self.wheelsSwitchMode.currentMode + 1;
		if nextMode > self.wheelsSwitchMode.maxMode then
			nextMode = 1;
		end;
		self:wheelsSwitchChangeMode(nextMode);
	end;
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(mrWheelsSwitchToggleModeEvent:new(self, self.wheelsSwitchMode.currentMode), nil, nil, self);
		else
			g_client:getServerConnection():sendEvent(mrWheelsSwitchToggleModeEvent:new(self, nil));
		end;
	end;
end;

function mrWheelsSwitch:wheelsSwitchChangeMode(newMode)
	self.wheelsSwitchMode.currentMode = newMode;
	
	if self.isClient then
		for i=1, self.wheelsSwitchMode.maxMode do
			for j=1, table.getn(self.wheelsSwitchMode[i].wheels) do
				setVisibility(self.wheelsSwitchMode[i].wheels[j], false);
			end;
		end;
		
		for j=1, table.getn(self.wheelsSwitchMode[self.wheelsSwitchMode.currentMode].wheels) do
			setVisibility(self.wheelsSwitchMode[self.wheelsSwitchMode.currentMode].wheels[j], true);
		end;
		
		self.realVehicleFlotationFx = self.wheelsSwitchMode[self.wheelsSwitchMode.currentMode].realVehicleFlotationFx;
		self.realRollingResistance = self.wheelsSwitchMode[self.wheelsSwitchMode.currentMode].realRollingResistance;
	end;
	self.wheelsSwitchMode.currentMass = mrWheelsSwitch.getCurrentMass(self);
end;

function mrWheelsSwitch:getCurrentMass()
	return self.wheelsSwitchMode[self.wheelsSwitchMode.currentMode].mass, self.wheelsSwitchMode[self.wheelsSwitchMode.currentMode].comTrans;
end;

function mrWheelsSwitch:getSaveAttributesAndNodes(nodeIdent)
	local attributes = string.format('currentWheels="%d"', self.wheelsSwitchMode.currentMode);
	return attributes, nil;
end;

function mrWheelsSwitch:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local wheelsSwitchMode = getXMLInt(xmlFile, key .. "#currentWheels");
		if wheelsSwitchMode ~= nil then
			self:wheelsSwitchChangeMode(wheelsSwitchMode);
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function mrWheelsSwitch:onLeave()
end;

function mrWheelsSwitch:delete()
end;

function mrWheelsSwitch:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mrWheelsSwitch:keyEvent(unicode, sym, modifier, isDown)
end;