--[[************************************************************************************************************************************************************
	
	mrFullPowershift v2.0.1 (with gear reduction) ... Events for MP and DS
	
	07/2014 © Saty MODS (Saty / http://forum.lsczech.cz)
	
****************************************************************************************************************************************************************
	
	Very thanks for :
	
	Dural - author of MoreRealistic mod & this specialization v1.0
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
	This work is licensed under a Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License (Attribution / NonCommercial / NoDerivatives)
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.en
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
	Toto dilo podleha licenci : Creative Commons 4.0 International - Uvedte autora / Neuzivejte dilo komercne / Nezasahujte do dila 
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.cs
	
************************************************************************************************************************************************************]]--

mrFullPowershiftSetGearEvent = {};
mrFullPowershiftSetGearEvent_mt = Class(mrFullPowershiftSetGearEvent, Event);

InitEventClass(mrFullPowershiftSetGearEvent, "mrFullPowershiftSetGearEvent");

 
function mrFullPowershiftSetGearEvent:emptyNew()
	local self = Event:new(mrFullPowershiftSetGearEvent_mt);
	self.className="mrFullPowershiftSetGearEvent";
	return self;
end;

function mrFullPowershiftSetGearEvent:new(object, gearNum)
	local self = mrFullPowershiftSetGearEvent:emptyNew();
	self.gearNum = gearNum;
	self.object = object;
	return self;
end;

function mrFullPowershiftSetGearEvent:readStream(streamId, connection)
	--both clients and server can receive this event
	local id = streamReadInt32(streamId);
	self.gearNum = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function mrFullPowershiftSetGearEvent:writeStream(streamId, connection)
	--both clients and server can send this event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.gearNum);
end;

function mrFullPowershiftSetGearEvent:run(connection)
	----both clients and server can "run" this event (after reading it)	
	
	if not connection:getIsServer() then
		--we are the server, and so, we need to broadcast the new gearnum to all the other clients
		self.object:setGear(self.gearNum, false);	
	else
		--we are the client, and so we just receive the new gearnum
		self.object:setGear(self.gearNum, true);	
	end;
end;


mrFullPowershiftSetReductionEvent = {};
mrFullPowershiftSetReductionEvent_mt = Class(mrFullPowershiftSetReductionEvent, Event);

InitEventClass(mrFullPowershiftSetReductionEvent, "mrFullPowershiftSetReductionEvent");

 
function mrFullPowershiftSetReductionEvent:emptyNew()
	local self = Event:new(mrFullPowershiftSetReductionEvent_mt);
	self.className="mrFullPowershiftSetReductionEvent";
	return self;
end;

function mrFullPowershiftSetReductionEvent:new(object, reducedGear)
	local self = mrFullPowershiftSetReductionEvent:emptyNew();
	self.reducedGear = reducedGear;
	self.object = object;
	return self;
end;

function mrFullPowershiftSetReductionEvent:readStream(streamId, connection)
	--both clients and server can receive this event
	local id = streamReadInt32(streamId);
	self.reducedGear = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function mrFullPowershiftSetReductionEvent:writeStream(streamId, connection)
	--both clients and server can send this event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.reducedGear);
end;

function mrFullPowershiftSetReductionEvent:run(connection)
	----both clients and server can "run" this event (after reading it)
	
	if not connection:getIsServer() then
		--we are the server, and so, we need to broadcast the new reducedGear to all the other clients
		self.object:setReduction(self.reducedGear, false);
	else
		--we are the client, and so we just receive the new reducedGear
		self.object:setReduction(self.reducedGear, true);
	end;
end;


mrFullPowershiftSetNextGearEvent = {};
mrFullPowershiftSetNextGearEvent_mt = Class(mrFullPowershiftSetNextGearEvent, Event);

InitEventClass(mrFullPowershiftSetNextGearEvent, "mrFullPowershiftSetNextGearEvent");

 
function mrFullPowershiftSetNextGearEvent:emptyNew()
	local self = Event:new(mrFullPowershiftSetNextGearEvent_mt);
	self.className="mrFullPowershiftSetNextGearEvent";
	return self;
end;

function mrFullPowershiftSetNextGearEvent:new(object, gearDown)
	local self = mrFullPowershiftSetNextGearEvent:emptyNew();
	self.gearDown = gearDown;
	self.object = object;
	return self;
end;

function mrFullPowershiftSetNextGearEvent:readStream(streamId, connection)
	--only the server receive the event
	local id = streamReadInt32(streamId);
	self.gearDown = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function mrFullPowershiftSetNextGearEvent:writeStream(streamId, connection)
	--only the clients send this event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.gearDown);
end;

function mrFullPowershiftSetNextGearEvent:run(connection)
	--only the server "run" this event (after reading it)	
	self.object:setNextGear(self.gearDown, true);	
end;