--[[************************************************************************************************************************************************************
	
	lightsAddon v 1.0.3 ... Events for MP and DS
	
	07/2014 © Saty MODS (Saty / http://forum.lsczech.cz)
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
	This work is licensed under a Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License (Attribution / NonCommercial / NoDerivatives)
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.en
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
	Toto dilo podleha licenci : Creative Commons 4.0 International - Uvedte autora / Neuzivejte dilo komercne / Nezasahujte do dila 
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.cs
	
************************************************************************************************************************************************************]]--


lightsAddonSetTurnStateEvent = {};
lightsAddonSetTurnStateEvent_mt = Class(lightsAddonSetTurnStateEvent, Event);

InitEventClass(lightsAddonSetTurnStateEvent, "lightsAddonSetTurnStateEvent");
 
function lightsAddonSetTurnStateEvent:emptyNew()
	local self = Event:new(lightsAddonSetTurnStateEvent_mt);
	self.className = "lightsAddonSetTurnStateEvent";
	return self;
end;

function lightsAddonSetTurnStateEvent:new(object, turnState)
	local self = lightsAddonSetTurnStateEvent:emptyNew();
	self.turnState = turnState;
	self.object = object;
	return self;
end;

function lightsAddonSetTurnStateEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.turnState = streamReadInt8(streamId);
	if self.object ~= nil then
		self:run(connection);
	end;
end;

function lightsAddonSetTurnStateEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.turnState);
end;

function lightsAddonSetTurnStateEvent:run(connection)
	self.object:setTurnState(self.turnState, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(lightsAddonSetTurnStateEvent:new(self.object, self.turnState), nil, connection, self.object);
	end;
end;

--

lightsAddonSetWorkLightsEvent = {};
lightsAddonSetWorkLightsEvent_mt = Class(lightsAddonSetWorkLightsEvent, Event);

InitEventClass(lightsAddonSetWorkLightsEvent, "lightsAddonSetWorkLightsEvent");
 
function lightsAddonSetWorkLightsEvent:emptyNew()
	local self = Event:new(lightsAddonSetWorkLightsEvent_mt);
	self.className = "lightsAddonSetWorkLightsEvent";
	return self;
end;

function lightsAddonSetWorkLightsEvent:new(object, worklight, mask)
	local self = lightsAddonSetWorkLightsEvent:emptyNew();
	self.light = worklight;
	self.mask = mask;
	self.object = object;
	return self;
end;

function lightsAddonSetWorkLightsEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.light = streamReadInt8(streamId);
	self.mask = streamReadBool(streamId);
	if self.object ~= nil then
		self:run(connection);
	end;
end;

function lightsAddonSetWorkLightsEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.light);
	streamWriteBool(streamId, self.mask);
end;

function lightsAddonSetWorkLightsEvent:run(connection)
	self.object:setWorkLightsTypesMask(self.light, self.mask, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(lightsAddonSetWorkLightsEvent:new(self.object, self.light, self.mask), nil, connection, self.object);
	end;
end;