--[[************************************************************************************************************************************************************
	
	RealisticBallastSave v1.0.1
	
	10/2013 © Saty MODS (Saty / http://forum.lsczech.cz)
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
	This work is licensed under a Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License (Attribution / NonCommercial / NoDerivatives)
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.en
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
	Toto dilo podleha licenci : Creative Commons 4.0 International - Uvedte autora / Neuzivejte dilo komercne / Nezasahujte do dila 
	http://creativecommons.org/licenses/by-nc-nd/4.0/deed.cs
	
************************************************************************************************************************************************************]]--

RealisticBallastSave = {};

function RealisticBallastSave.prerequisitesPresent(specializations)
	return true;
end;

function RealisticBallastSave:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local realBallastMode = Utils.getNoNil(getXMLFloat(xmlFile, key.."#realBallast"), 0);
		if self.realBallastMode ~= nil then
			if self.realBallastMode.currentMode ~= realBallastMode then
				self:realBallastChangeMode(realBallastMode);
			end;
		end;
	end; 
	return BaseMission.VEHICLE_LOAD_OK;
end;

function RealisticBallastSave:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;
	if self.realBallastMode ~= nil then
		attributes = 'realBallast="'.. tostring(self.realBallastMode.currentMode) .. '"';
	end
	return attributes, nil;
end;

function RealisticBallastSave:load(xmlFile)
end;

function RealisticBallastSave:delete()
end;

function RealisticBallastSave:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticBallastSave:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticBallastSave:update(dt)
end;

function RealisticBallastSave:draw()
end;