-- 
-- specialization for Schwungrad of Lanz
-- 22/01/13
-- author: fendtfahrer(95)
--

Schwungrad = {};

function Schwungrad.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Schwungrad:load(xmlFile)
	
    self.Schwungrad = {};
	self.Schwungrad.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schwungrad#index"));
	self.Schwungrad.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Schwungrad#speedFactor"), 1);
end;

function Schwungrad:delete()
end;

function Schwungrad:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Schwungrad:keyEvent(unicode, sym, modifier, isDown)
end;

function Schwungrad:update(dt)	
end;

function Schwungrad:updateTick(dt)
	if self.isMotorStarted then
		if self:getIsActive() then	
			rotate(self.Schwungrad.node,0, self.Schwungrad.speedFactor,0); 
		end;
	end;
end;

function Schwungrad:draw()		
end;
