-- by modelleicher
-- www.schwabenmodding.bplaced.net

SchlueterAnimations = {};

function SchlueterAnimations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function SchlueterAnimations:load(xmlFile)
	-- Zapfwellenstummel / Powershaft rotation
	self.stummelIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations#zapfwellenStummelIndex"));
	
	-- Ladekontrollleuchte / Batterie load light
	self.ladeLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.LadeKontrollLeuchte#index"));
	setVisibility(self.ladeLeuchte, false);
	self.ladeLeuchteOn = 0;
	self.ladeTimer = 50;
	
end;
function SchlueterAnimations:delete()
end;
function SchlueterAnimations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function SchlueterAnimations:keyEvent(unicode, sym, modifier, isDown)
end;

function SchlueterAnimations:updateTick(dt)
end;

function SchlueterAnimations:update(dt)
	if self:getIsActive() then
		if self.isMotorStarted then
			-- Ladekontrollleuchte / Batterie load light
			if self.ladeLeuchteOn == 1 then
				setVisibility(self.ladeLeuchte, true);
				if self.movingDirection ~= 0 then
					self.timerTrue = true;
				end;
				if self.timerTrue then
					self.ladeTimer = math.max(self.ladeTimer - 0.1, 0);
				end;
				if self.ladeTimer == 0 then
					setVisibility(self.ladeLeuchte, false);
					self.timerTrue = nil;
					self.ladeLeuchteOn = 0;
					self.ladeTimer = 50;
				end;
			end;		
		
			-- Zapfwellenstummel / Powershaft rotation
			rotate(self.stummelIndex, 0,0,0.001*dt);			
		end;
	end;
end;
function SchlueterAnimations:draw()
end;

function SchlueterAnimations:onEnter()
	self.ladeLeuchteOn = 1;
end;
function SchlueterAnimations:onLeave()
	self.ladeLeuchteOn = 0;
end;

