RealisticTedder = {};

function RealisticTedder.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations);
end;


function RealisticTedder:load(xmlFile) 

	self.isRealistic = true;
	
	self.realOnDesactivatePS = SpecializationUtil.callSpecializationsFunction("realOnDesactivatePS");

	self.realTedderWorkingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTedderWorkingPowerConsumption"), 0);	
	self.realTedderWorkingPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realTedderWorkingPowerConsumptionInc"), 0);
	self.realWorkingSpeedLimit = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realWorkingSpeedLimit"), 16); --kph
	
	--called within RealisticVehicle:draw
	self.realGetIsWorkingTooFast = RealisticTedder.realGetIsWorkingTooFast;
	
	self.realCurrentPowerConsumption = 0;
	self.realLastTeddedArea = 0
	self.realTeddedAreaS = 0;
	
end;

function RealisticTedder:delete()    
end;

function RealisticTedder:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticTedder:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticTedder:updateTick(dt)	

	if self.isServer and self.isActive then
		
		self.realCurrentPowerConsumption = 0;
		if self.isTurnedOn then -- the tedder is active
			self.realCurrentPowerConsumption = self.realTedderWorkingPowerConsumption;
			--realLastTeddedArea = pixel			
			self.realTeddedAreaS = 0.9*self.realTeddedAreaS + 0.1*self.realLastTeddedArea*g_currentMission:getFruitPixelsToSqm();
			self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realTeddedAreaS*self.realTedderWorkingPowerConsumptionInc/(0.06*dt)*math.min(1, 4*self.realGroundSpeed);			
		else
			self.realTeddedAreaS = 0;
		end;		
		
	end;

end;


function RealisticTedder:update(dt)
end;

function RealisticTedder:draw() 		
end;

function RealisticTedder:realOnDesactivatePS()
	
	for k,v in pairs(self.grassParticleSystems) do
		v.isEnabled = false;
		Utils.setEmittingState(v.ps, false);
	end;

end;


--called within RealisticVehicle:draw
RealisticTedder.realGetIsWorkingTooFast = function(self)
	--print(self.time .. " " .. tostring(self.realVehicleName) .. " calling realGetIsWorkingTooFast. wasToFast=" .. tostring(self.wasToFast) .. " realWorkingSpeedLimit="..tostring(self.realWorkingSpeedLimit));
	return self.wasToFast, self.realWorkingSpeedLimit;
end;



