RealisticSteerableToggleTransmissionModeEvent = {};
RealisticSteerableToggleTransmissionModeEvent_mt = Class(RealisticSteerableToggleTransmissionModeEvent, Event);

InitEventClass(RealisticSteerableToggleTransmissionModeEvent, "RealisticSteerableToggleTransmissionModeEvent");

 
function RealisticSteerableToggleTransmissionModeEvent:emptyNew()
	local self = Event:new(RealisticSteerableToggleTransmissionModeEvent_mt);
	self.className="RealisticSteerableToggleTransmissionModeEvent";
	return self;
end;

function RealisticSteerableToggleTransmissionModeEvent:new(object, transMode)
	local self = RealisticSteerableToggleTransmissionModeEvent:emptyNew();
	self.transMode = transMode;
	self.object = object;
	return self;
end;

function RealisticSteerableToggleTransmissionModeEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	if connection:getIsServer() then
		--client receive more data than the server. client need the transMode
		self.transMode = streamReadInt8(streamId);
	end;
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticSteerableToggleTransmissionModeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	if not connection:getIsServer() then
		--server send more data than the client => add the transMode
		streamWriteInt8(streamId, self.transMode);
	end;
end;

function RealisticSteerableToggleTransmissionModeEvent:run(connection)	
	if not connection:getIsServer() then
		--server side => set the next transmission mode and then broadcast the resulting currentMode to all the clients
		self.object:realSetNextTransmissionMode();		
	else
		--client side => just set the new Transmission mode received from the server
		self.object.realTransmissionMode.currentMode = self.transMode;
	end;
end;